
//#line 1 "age8481a.cs"
/* Copyright (C) 2001 Agilent Technologies Company */
/* VXIplug&play Instrument Driver for the age8481a*/

/*=============================*/
/*           age8481a           */
/*=============================*/
/* Framework Revision: WIN95 4.0 */
/*                     WINNT 4.0 */
/* Driver Revision:    A.01.00 */
/* Firmware Revision:  G.11.01 */
/*=============================*/

/*=============================*/
/* Source Files:               */
/*=============================*/
/*   age8481a.c                 */
/*   age8481a.h                 */
/*=============================*/

/*=============================*/
/* WIN Framework Files         */
/*=============================*/
/*   age8481a.def               */
/*   age8481a.mak               */
/*   age8481a.bas               */
/*=============================*/
#include <stdlib.h>		/* prototype for malloc() */
#include <string.h>		/* prototype for strcpy() */
#include <stdio.h>		/* prototype for sprintf() */
#include <windows.h>
#include "cscpiv.h"		/* includes cscpi and visa calls */
#define INSTR_CALLBACKS		/* needed to get handler types in age8481a.h */
#include "age8481a.h"

#define age8481a_MODEL_CODE 0x02d1	/* E8481A */
#define age8481a_MANF_ID     4095	
#define age8481a_IDN_STRING  "HEWLETT-PACKARD,SWITCHBOX"

#define age8481a_REV_CODE "A.01.00"  /* Driver Revision */

#define age8481a_ERR_MSG_LENGTH 256  /* size of error message buffer */

#define age8481a_MAX_STAT_HAP 37		    /* number of happenings ??? */
#define age8481a_MAX_STAT_REG 4		    /* number of IEEE 488.2 status registers */

/* this has to match the index of the ESR register in age8481a_accessInfo[] */
#define age8481a_ESR_REG_IDX 2

/* this needs to match the index location of age8481a_USER_ERROR_HANLDER
 * in the age8481a_statusHap[] array.  Normally, this is zero.
 */
#define age8481a_USER_ERROR_HANDLER_IDX 0

/*=============================================================== 
 *
 *  All messages are stored in this area to aid in localization 
 *
 *=============================================================== 
 */

#define age8481a_MSG_VI_OPEN_ERR 				\
	"vi was zero.  Was the age8481a_init() successful?"

#define age8481a_MSG_CONDITION					\
	"condition"
	/* age8481a_statCond_Q() */

#define age8481a_MSG_EVENT						\
	"event"	
	/* age8481a_statEvent_Q() */

#define age8481a_MSG_EVENT_HDLR_INSTALLED				\
	"event handler is already installed for event happening"
	/* age8481a_statEvent_Q() */

#define age8481a_MSG_EVENT_HDLR_INST2				\
	"Only 1 handler can be installed at a time."	
	/* age8481a_statEvent_Q() */

#define age8481a_MSG_INVALID_HAPPENING				\
	"is not a valid happening."
	/* age8481a_statCond_Q() */
	/* age8481a_statEven_Q() */
	/* age8481a_statEvenHdlr() */
	/* age8481a_statEvenHdlr_Q() */

#define age8481a_MSG_NOT_QUERIABLE					\
	"is not queriable."	
	/* age8481a_statCond_Q() */
	/* age8481a_statEven_Q() */


#define age8481a_MSG_IN_FUNCTION					\
	"in function" 		
	/* age8481a_error_message() */

#define age8481a_MSG_INVALID_STATUS					\
  	"Parameter 2 is invalid"				\
	"in function age8481a_error_message()."
	/* age8481a_error_message() */

#define age8481a_MSG_INVALID_STATUS_VALUE				\
	"is not a valid viStatus value."
	/* age8481a_error_message() */

#define  age8481a_MSG_INVALID_VI					\
  	"Parameter 1 is invalid"				\
	" in function age8481a_error_message()"			\
	".  Using an inactive ViSession may cause this error."	\
	"  Was the instrument driver closed prematurely?"
	/* age8481a_message_query() */

#define age8481a_MSG_NO_ERRORS					\
	"No Errors"
	/* age8481a_error_message() */

#define age8481a_MSG_SELF_TEST_FAILED 				\
	"Self test failed." 	
	/* age8481a_self_test() */

#define age8481a_MSG_SELF_TEST_PASSED 				\
	"Self test passed."
	/* age8481a_self_test() */

/* the following messages are used by the functions to check parameters */

#define age8481a_MSG_BOOLEAN   "Expected 0 or 1; Got %d"

#define age8481a_MSG_REAL   "Expected %lg to %lg; Got %lg"
   
#define age8481a_MSG_INT   "Expected %hd to %hd; Got %hd"

#define age8481a_MSG_LONG   "Expected %ld to %ld; Got %ld"

#define age8481a_MSG_LOOKUP "Error converting string response to integer"

#define age8481a_MSG_NO_MATCH "Could not match string %s"

/* 
 * static error message 
 */

#define VI_ERROR_PARAMETER1_MSG				\
	"Parameter 1 is invalid"

#define VI_ERROR_PARAMETER2_MSG				\
	"Parameter 2 is invalid"

#define VI_ERROR_PARAMETER3_MSG				\
	"Parameter 3 is invalid"

#define VI_ERROR_PARAMETER4_MSG				\
	"Parameter 4 is invalid"

#define VI_ERROR_PARAMETER5_MSG				\
	"Parameter 5 is invalid"

#define VI_ERROR_PARAMETER6_MSG				\
	"Parameter 6 is invalid"

#define VI_ERROR_PARAMETER7_MSG				\
	"Parameter 7 is invalid"

#define VI_ERROR_PARAMETER8_MSG				\
	"Parameter 8 is invalid"

#define VI_ERROR_FAIL_ID_QUERY_MSG				\
	"Instrument IDN does not match."

#define INSTR_ERROR_INV_SESSION_MSG 				\
	"ViSession (parmeter 1) was not created by this driver"

#define INSTR_ERROR_NULL_PTR_MSG				\
	"NULL pointer detected"

#define INSTR_ERROR_RESET_FAILED_MSG				\
	"reset failed"

#define INSTR_ERROR_UNEXPECTED_MSG 				\
	"An unexpected error occurred"

#define INSTR_ERROR_DETECTED_MSG			\
	"Instrument Error Detected, call age8481a_error_query()."

#define INSTR_ERROR_LOOKUP_MSG   				\
	"String not found in table"

/*================================================================*/

#define age8481a_DEBUG_CHK_THIS( vi, thisPtr) 			\
	/* check for NULL user data */				\
	if( 0 == thisPtr)					\
	{							\
 		age8481a_LOG_STATUS(                             	\
		  vi, NULL, age8481a_INSTR_ERROR_INV_SESSION );	\
	}							\
	{							\
		ViSession defRM;				\
								\
		/* This should never fail */			\
		errStatus = viGetAttribute( vi,                 \
			VI_ATTR_RM_SESSION, &defRM);		\
		if( VI_SUCCESS > errStatus )			\
		{						\
 			age8481a_LOG_STATUS(				\
			  vi, NULL, age8481a_INSTR_ERROR_UNEXPECTED );	\
		}						\
		if( defRM != thisPtr->defRMSession)		\
		{						\
 			age8481a_LOG_STATUS(				\
			  vi, NULL, age8481a_INSTR_ERROR_INV_SESSION );	\
		}						\
	}

#define age8481a_DEBUG_CHK_NULL_PTR( vi, ptr) 			\
	if( 0 == ptr) 						\
	{							\
 		age8481a_LOG_STATUS( 				\
		   vi, NULL, age8481a_INSTR_ERROR_NULL_PTR );	\
	}

#define age8481a_CDE_INIT( funcname)  				\
	strcpy(thisPtr->errFuncName, funcname);			\
	thisPtr->errNumber = VI_SUCCESS;			\
	thisPtr->errMessage[0] = 0;

#define age8481a_CDE_MESSAGE( message ) 	 			\
	strcpy(thisPtr->errMessage, message)

#define age8481a_CDE_ERROR( status)					\
	thisPtr->errNumber = status		

struct age8481a_eventHdlrStruct
{
	age8481a_InstrEventHandler eventHandler;
	ViAddr userData;
};

struct age8481a_globals
{
	ViSession			defRMSession;

	ViStatus			errNumber;
	char 				errFuncName[40];
	char				errMessage[160];

	ViBoolean			errQueryDetect;

	ViInt32 			driverEventArray[age8481a_MAX_STAT_REG];
	ViInt32 			numEventHandlers;
	struct age8481a_eventHdlrStruct	eventHandlerArray[age8481a_MAX_STAT_HAP];
	ViBoolean			e1406; /* 1 if gpib to 1406*/

        /* Setting this to VI_TRUE,
         * will prevent I/O from occuring in an SRQ
         * This is needed, because VTL 3.0 doesn't provide
         * an atomic write/read operations.  Don't want
         * to do I/O if the driver is in the middle of
         * a read from the instrument.
         */
	ViBoolean                       blockSrqIO;
	ViInt32                         countSrqIO;
};
/* add the following to the globals data structure */

/* Note: for debugging, you can add __FILE__, __LINE__ as parameters
 * to age8481a_LOG_STATUS, and ViString filename, and ViInt32 lineNumber to
 * age8481a_statusUpdate() in order to determine exactly where an error
 * occured in a driver.
 */
#define age8481a_LOG_STATUS( vi, thisPtr, status ) 	\
  return age8481a_statusUpdate( vi, thisPtr, status)

/* declare this here since it is called by statusUpdate */
static void age8481a_srqTraverse(ViSession vi, ViInt32 eventReg);

static ViStatus age8481a_statusUpdate(INST vi,
									  struct age8481a_globals *thisPtr,
									  ViStatus status)
{
	ViInt32  eventQ;

	/* ALL functions exit through here.
	 *
	 * this allows errors to be trapped and
	 * a user error handler could be called.
	 */

	/* can do nothing without state structure*/
	if (!thisPtr) return status;

	/* Check if user wants to query the instrument state.
         * This is only done, if the vi is valid and 
         * no other errors has occured.
         */
	if( VI_TRUE == thisPtr->errQueryDetect && 
		VI_SUCCESS <= status &&
		vi != VI_NULL )
	{
		/* assume IEEE 488.2 Instrument and query standard
		 * status event register for a parser error
		 */	
		if (thisPtr->e1406)
		{
			thisPtr->blockSrqIO = VI_TRUE;

			status = viPrintf(vi, "*esr?\n");
			if( VI_SUCCESS <= status) 
			{
				status = viScanf(vi, "%ld%*t\n", &eventQ);
			}  /* viPrintf was successful */
		} 
		else
		{
			{{ struct {double p1[1];} out_;
//#line 315 "age8481a.cs"
{extern com_esr_q();if (!instr_query(vi,com_esr_q,(void*)0,&out_)){
//#line 315 "age8481a.cs"
*&eventQ=(*(HPSL_INT16*)out_.p1).num;}}}}
		}
		if( VI_SUCCESS <= status)
		{

		    /* update driver's copy of the esr register 
       		 * This index 'age8481a_ESR_REG_IDX' should 
		     * match the access event register array 
		     * and correspond to the 
      		 * standard event status register.
       		 */
		    thisPtr->driverEventArray[age8481a_ESR_REG_IDX] = 
		      thisPtr->driverEventArray[age8481a_ESR_REG_IDX] | eventQ;

		    /* see if the instrument thinks an error occured */
		    if( ( 0x04 /* Query Error */
				  | 0x08 /* Device Dependent Error */
				  | 0x10 /* Execution Error */
				  | 0x20 /* Command Error */
				) & eventQ )
		    {
			/* set our error status, to indicate that a 
			 * instrument error occured.
             */
				status =  age8481a_INSTR_ERROR_DETECTED;
		    } 
		} /* INST_QUERY or viScanf was successful */
	} /* if we need to query the instrument */	

	/* check if we need to service SRQ events */
	if( 0 != thisPtr->countSrqIO && VI_NULL != vi )
	{
		ViStatus errStatus;
		
		/* suspend event processing for now */
		errStatus = viEnableEvent( vi, VI_EVENT_SERVICE_REQ,
								   VI_SUSPEND_HNDLR, VI_NULL);
		if( VI_SUCCESS > errStatus )
		{
			/* an existing error message has priority */
			if( VI_SUCCESS <= status)
			{
				/* no existing error message, so set new error */
				status = errStatus;
			}
		} /* if - an error occured */
		else
		{
			/* reset the srq counter */
			thisPtr->countSrqIO = 0;
			
			/* recursively traverse status byte */
			age8481a_srqTraverse( vi, 0);

			/* re-enable event processing */
			errStatus = viEnableEvent( vi, VI_EVENT_SERVICE_REQ,
									   VI_HNDLR, VI_NULL);
			if( VI_SUCCESS > errStatus )
			{
				/* an existing error message has priority */
				if( VI_SUCCESS <= status)
				{
					/* no existing error message, so set new error */
					status = errStatus;
				}
			} /* if - an error occured */

		} /* else - no error in viEnableEvent */

	} /* if - srq needs servicing */

	/* unblock IO in SRQs */
	thisPtr->blockSrqIO = VI_FALSE;

	/* store the context dependent error number */
	age8481a_CDE_ERROR(status);

	/* if an error occurs, see if the user has an error handler enabled */
	if( status != age8481a_INSTR_ERROR_DETECTED &&
	    VI_SUCCESS > status &&
	    thisPtr->eventHandlerArray[
	        age8481a_USER_ERROR_HANDLER_IDX].eventHandler)
	{
		/* call the users handler */
		thisPtr->eventHandlerArray[
		    age8481a_USER_ERROR_HANDLER_IDX].eventHandler(
			vi, (ViInt32)status, 
			thisPtr->eventHandlerArray[
			    age8481a_USER_ERROR_HANDLER_IDX].userData);
	}
	/* return the appropriate error number */
	return status;
}

/* 
 * Error Message Structures
 */

struct instrErrStruct
{
	ViStatus errStatus;
	ViString errMessage;
};

const static struct instrErrStruct instrErrMsgTable[] =
{
	{ VI_ERROR_PARAMETER1,	VI_ERROR_PARAMETER1_MSG },
	{ VI_ERROR_PARAMETER2,	VI_ERROR_PARAMETER2_MSG },
	{ VI_ERROR_PARAMETER3,	VI_ERROR_PARAMETER3_MSG },
	{ VI_ERROR_PARAMETER4,	VI_ERROR_PARAMETER4_MSG },
	{ VI_ERROR_PARAMETER5,	VI_ERROR_PARAMETER5_MSG },
	{ VI_ERROR_PARAMETER6,	VI_ERROR_PARAMETER6_MSG },
	{ VI_ERROR_PARAMETER7,	VI_ERROR_PARAMETER7_MSG },
    { VI_ERROR_PARAMETER8,	VI_ERROR_PARAMETER8_MSG },
    { VI_ERROR_FAIL_ID_QUERY,	VI_ERROR_FAIL_ID_QUERY_MSG },

	{ age8481a_INSTR_ERROR_INV_SESSION,	INSTR_ERROR_INV_SESSION_MSG },
	{ age8481a_INSTR_ERROR_NULL_PTR,	INSTR_ERROR_NULL_PTR_MSG },
	{ age8481a_INSTR_ERROR_RESET_FAILED,INSTR_ERROR_RESET_FAILED_MSG },
	{ age8481a_INSTR_ERROR_UNEXPECTED,	INSTR_ERROR_UNEXPECTED_MSG },
	{ age8481a_INSTR_ERROR_DETECTED,	INSTR_ERROR_DETECTED_MSG },
	{ age8481a_INSTR_ERROR_LOOKUP,	INSTR_ERROR_LOOKUP_MSG },
};

/* macros for testing parameters */
#define age8481a_CHK_BOOLEAN( my_val, err ) if( age8481a_chk_boolean( thisPtr, my_val) ) age8481a_LOG_STATUS( vi, thisPtr, err);

static ViBoolean age8481a_chk_boolean(struct age8481a_globals *thisPtr,
									  ViBoolean my_val)
{
	char message[age8481a_ERR_MSG_LENGTH];
	if( (my_val != VI_TRUE) && (my_val != VI_FALSE) )
	{
		/* true = parameter is invalid */
		sprintf(message, age8481a_MSG_BOOLEAN, my_val);	
		age8481a_CDE_MESSAGE(message);				
		/* true = parameter is invalid */
		return VI_TRUE;
	}
	/* false = okay */
	return VI_FALSE;
}

#define age8481a_CHK_REAL_RANGE( my_val, min, max, err ) if( age8481a_chk_real_range( thisPtr, my_val, min, max) ) age8481a_LOG_STATUS( vi, thisPtr, err);

static ViBoolean age8481a_chk_real_range(struct age8481a_globals *thisPtr,
										 ViReal64 my_val,
										 ViReal64 min,
										 ViReal64 max)
{
	char message[age8481a_ERR_MSG_LENGTH];

	if ( ( my_val < min ) || (my_val > max) )
	{
		sprintf(message, age8481a_MSG_REAL, min, max, my_val);	
		age8481a_CDE_MESSAGE(message);
		/* true = parameter is invalid */
		return VI_TRUE;
	}
	return VI_FALSE;
} 
   
#define age8481a_CHK_INT_RANGE( my_val, min, max, err ) if( age8481a_chk_int_range( thisPtr, my_val, min, max) ) age8481a_LOG_STATUS( vi, thisPtr, err);

static ViBoolean age8481a_chk_int_range(struct age8481a_globals *thisPtr,
										ViInt16 my_val,
										ViInt16 min,
										ViInt16 max)
{
	char message[age8481a_ERR_MSG_LENGTH];

	if ( ( my_val < min ) || (my_val > max) )  			
	{								
		sprintf(message, age8481a_MSG_INT, min, max, my_val);	
		age8481a_CDE_MESSAGE(message);				
		/* true = parameter is invalid */
		return VI_TRUE;
	}
	return VI_FALSE;
} 
   
#define age8481a_CHK_LONG_RANGE( my_val, min, max, err ) if( age8481a_chk_long_range( thisPtr, my_val, min, max) ) age8481a_LOG_STATUS( vi, thisPtr, err);

static ViBoolean age8481a_chk_long_range(struct age8481a_globals *thisPtr,
										 ViInt32 my_val,
										 ViInt32 min,
										 ViInt32 max)
{
	char message[age8481a_ERR_MSG_LENGTH];

	if ( ( my_val < min ) || (my_val > max) )  			
	{								
		sprintf(message, age8481a_MSG_LONG, min, max, my_val);	
		age8481a_CDE_MESSAGE(message);				
		/* true = parameter is invalid */
		return VI_TRUE;
	}
	return VI_FALSE;
} 
   
#define age8481a_CHK_ENUM( my_val, limit, err ) if( age8481a_chk_enum( thisPtr, my_val, limit) ) age8481a_LOG_STATUS( vi, thisPtr, err);

/* utility routine which searches for a string in an array of strings. */
/* This is used by the CHK_ENUM macro */
static ViBoolean age8481a_chk_enum (struct age8481a_globals *thisPtr,
									ViInt16 my_val,
									ViInt16 limit)
{
    char message[age8481a_ERR_MSG_LENGTH];

    if ( ( my_val < 0 ) || (my_val > limit) )  			
    {								
        sprintf(message, age8481a_MSG_INT, 0, limit, my_val);	
        age8481a_CDE_MESSAGE(message);				
        /* true = parameter is invalid */
        return VI_TRUE;
    }
    return VI_FALSE;
}

/*  ==========================================================================  
     This function searches an array of strings for a specific string and     
     returns its index.  If successful, a VI_SUCCESS is returned, 
     else age8481a_INSTR_ERROR_LOOKUP is returned.
    ======================================================================== */
ViStatus age8481a_findIndex (struct age8481a_globals *thisPtr,
							 const char * const array_of_strings[],
							 /*last entry in array must be 0 */
							 const char *string, /* string read from instrument */
							 ViPInt16 index) /* result index */
{
    ViInt16 i;
    ViInt16 my_len;
    char search_str[20];
    char message[80];

    strcpy(search_str, string);

	/* get rid of newline if present in string */
	/* needed because %s includes newline in some VTL's */
    my_len = strlen(search_str);
    if (search_str[my_len - 1] == '\n')
       search_str[my_len - 1] = '\0';

    for (i = 0; array_of_strings[i]; i++)
    {
		if (!strcmp (array_of_strings[i], search_str))
		{
			*index = i;
			return VI_SUCCESS;
		}
    }

	/* if we got here, we did not find it */
    sprintf(message, age8481a_MSG_NO_MATCH, search_str);	
    age8481a_CDE_MESSAGE(message);				
    return age8481a_INSTR_ERROR_LOOKUP;
}

static const ViStatus cscpi_error_to_vi_error[] = {
	VI_ERROR_SYSTEM_ERROR,
	VI_ERROR_SYSTEM_ERROR, /* should never happen*/
	VI_ERROR_FAIL_ID_QUERY, /* 2 wrong card type*/
	VI_ERROR_ALLOC,		/* 3 out of memory*/
	VI_ERROR_INV_RSRC_NAME, /* 4 bad address*/
	VI_ERROR_RSRC_NFOUND,	/* 5 open failed*/
	VI_ERROR_SYSTEM_ERROR, /*  6 open go system error*/
	VI_ERROR_SYSTEM_ERROR, /*  7 internal errors*/
	VI_ERROR_SYSTEM_ERROR, /*  8 internal errors*/
	VI_ERROR_SYSTEM_ERROR, /*  9 internal errors*/
	VI_ERROR_SYSTEM_ERROR, /*  10 internal errors*/
	VI_ERROR_SYSTEM_ERROR, /*  11 internal errors*/
	VI_ERROR_SYSTEM_ERROR, /*  12 internal errors*/
	VI_ERROR_SYSTEM_ERROR, /*  13 internal errors*/
	VI_ERROR_SYSTEM_ERROR, /*  14 internal errors*/
};

/****************************************************************************
age8481a_init
*****************************************************************************
    Parameter Name                                       Type    Direction
   ------------------------------------------------------------------------
  | InstrDesc                                         ViRsrc      IN
  |   ---------------------------------------------------------------------
  |  | The Instrument Description.
  |  |
  |  | Examples: VXI::5, GPIB-VXI::128::INSTR
   ------------------------------------------------------------------------
  | id_query                                          ViBoolean   IN
  |   ---------------------------------------------------------------------
  |  | if( VI_TRUE) Perform In-System Verification.
  |  | if(VI_FALSE) Do not perform In-System Verification
   ------------------------------------------------------------------------
  | do_reset                                          ViBoolean   IN
  |   ---------------------------------------------------------------------
  |  | IF( VI_TRUE) Perform Reset Operation.
  |  | if(VI_FALSE) Do not perform Reset operation
   ------------------------------------------------------------------------
  | vi                                                ViPSession  OUT
  |   ---------------------------------------------------------------------
  |  | Instrument Handle. This is VI_NULL if an error occurred
  |  | during the init.

*****************************************************************************/

ViStatus _VI_FUNC age8481a_init (ViRsrc InstrDesc, 
								 ViBoolean id_query,
								 ViBoolean do_reset,
								 ViPSession vi )
{
	struct age8481a_globals *thisPtr;
	ViStatus errStatus;
	ViSession defRM;
	ViUInt16 intf;
	ViUInt16 manfId;
	ViUInt16 modelCode;
	ViInt32 idx;

	*vi = VI_NULL;

	/* Find the Default Resource Manager */
	errStatus = viOpenDefaultRM( &defRM);
	if( VI_SUCCESS > errStatus)
	{
		/* Errors: VI_ERROR_SYSTEM_ERROR 
		 *         VI_ERROR_ALLOC
		 */
		age8481a_LOG_STATUS( *vi, NULL, errStatus);
	}

	/* Open a session to the instrument */
	errStatus = viOpen( defRM, InstrDesc, VI_NULL, VI_NULL, vi);
	if( VI_SUCCESS > errStatus)
	{
		/* can't open using vtl, try register based open*/
		intf = VI_INTF_VXI;
		goto gpib_check_done;
	}
	
	if( errStatus = viGetAttribute( *vi, VI_ATTR_INTF_TYPE, &intf) )
	{
		viClose( *vi);
		viClose( defRM);
		*vi = VI_NULL;
		age8481a_LOG_STATUS( *vi, NULL, errStatus);
	}

	/* check for 1406 internal driver by reading *IDN? of 0 and
	 *IDN? of secondary for this address*/
	if (intf == VI_INTF_GPIB_VXI)
	{
		char gpibdesc[64];
		ViUInt16 num, primary, secondary;
		ViSession vi1406;
		char idn_buf[256];

		/* Can't use VI_ATTR_INTF_NUM since
		/* HP VTL 3.0 has a defect which returns 7 instead of 0*/
		/* Read the number from the descriptor instead, assuming
			it's GPIB-VXIn.
		/* Set the GPIB board number is the same had the GPIB-VXI 
			board number*/
		if (memcmp(InstrDesc, "GPIB-VXI", 8) || 
			InstrDesc[8] < '0' || InstrDesc[8] > '9')
			num = 0;
		else
			num = (ViUInt16) atoi(InstrDesc+8);
		viGetAttribute(*vi, VI_ATTR_GPIB_PRIMARY_ADDR, &primary);
		sprintf(gpibdesc, "GPIB%d::%d::0", num,	primary);
		errStatus = viOpen( defRM, gpibdesc, VI_NULL, VI_NULL, 
						    &vi1406);
		if (errStatus < VI_SUCCESS)
			goto gpib_check_done;

		/* try sending an IDN? to 1406 */
		viSetAttribute(vi1406, VI_ATTR_TMO_VALUE, 1000); 
		errStatus = viClear(vi1406);
		if (errStatus < VI_SUCCESS)
		{
			viClose(vi1406);
			goto gpib_check_done;
		}

		errStatus = viPrintf(vi1406, "*IDN?\n");
		if (errStatus < VI_SUCCESS)
		{
			viClose(vi1406);
			goto gpib_check_done;
		}

		/* it worked, try getting response and check it*/
		errStatus = viScanf( vi1406, "%t", idn_buf);
		viClose(vi1406);
		if (errStatus < VI_SUCCESS || 
				memcmp(idn_buf, "HEWLETT-PACKARD,E140", 20))
			goto gpib_check_done;

		/* try sending an IDN? to the card drivers*/
		viSetAttribute(*vi, VI_ATTR_TMO_VALUE, 1000); 
		errStatus = viClear(*vi);
		if (errStatus < VI_SUCCESS)
			goto gpib_check_done;

		errStatus = viPrintf(*vi, "*IDN?\n");
		if (errStatus < VI_SUCCESS)
			goto gpib_check_done;

		/* it worked, try getting response*/
		errStatus = viScanf( *vi, "%t", idn_buf);
		if (errStatus < VI_SUCCESS)
			goto gpib_check_done;

		/* got an answer so switch vi to gpib mode */
		viGetAttribute(*vi, VI_ATTR_GPIB_SECONDARY_ADDR, &secondary);
		sprintf(gpibdesc, "GPIB%d::%d::%d", num, primary, secondary);
		viClose(*vi);
		errStatus = viOpen( defRM, gpibdesc, VI_NULL, VI_NULL, vi);
		if( errStatus < VI_SUCCESS)
		{ /* this should never happen*/	
			viClose( defRM);
			*vi = VI_NULL;
			age8481a_LOG_STATUS( *vi, NULL, errStatus);
		}
		intf = VI_INTF_GPIB;
	}

gpib_check_done:
	/* get memory for instance specific globals */
	thisPtr = (struct age8481a_globals *)malloc(sizeof( struct age8481a_globals) );
	if( 0 == thisPtr)
	{
		viClose( defRM);	/* also closes vi session */
		*vi = VI_NULL;
		age8481a_LOG_STATUS(*vi, NULL, VI_ERROR_ALLOC);
	}

	if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
	{
		/* associate memory with session, should not fail because
		 *   session is valid; and attribute is defined, supported,
		 *   and writable.
		 */
		errStatus = viSetAttribute(*vi, VI_ATTR_USER_DATA, 
								   (ViAttrState)thisPtr); 
		if( VI_SUCCESS > errStatus)
		{
			viClose( *vi);
			viClose( defRM);	/* also closes vi session */
			*vi = VI_NULL;
			age8481a_LOG_STATUS(*vi, NULL, errStatus);
		}
		thisPtr->e1406 = 1;
	}
	else
	{
		/* reg based drivers open their own sessions*/
		viClose( defRM);	/* also closes vi session */

		/* start pos if not started*/
		os_init();/* STARTUP */

		{extern switch_header_fn();*vi = os_open(InstrDesc,switch_header_fn);}

		if (!*vi)
		{
			if (cscpi_open_error >= 0 && cscpi_open_error <= 14)
				age8481a_LOG_STATUS(*vi, NULL,
			       	cscpi_error_to_vi_error[cscpi_open_error]);
			else
				age8481a_LOG_STATUS(*vi, NULL, VI_ERROR_SYSTEM_ERROR);
		}

		/* associate memory with session */
		instr_setdata(*vi, thisPtr); 
		thisPtr->e1406 = 0;
	}
	/* initialize instance globals */
	viGetAttribute( *vi, VI_ATTR_RM_SESSION, &thisPtr->defRMSession);
	thisPtr->errNumber = VI_SUCCESS;
	thisPtr->errFuncName[0] = 0;
	thisPtr->errMessage[0] = 0;
	thisPtr->errQueryDetect = VI_FALSE;
	thisPtr->blockSrqIO = VI_FALSE;
	thisPtr->countSrqIO = 0;

	for( idx=0;idx<age8481a_MAX_STAT_REG; idx++)
	{
	    thisPtr->driverEventArray[idx] = 0;
	}
	thisPtr->numEventHandlers = 0;
	for( idx=0;idx<age8481a_MAX_STAT_HAP; idx++)
	{
	    thisPtr->eventHandlerArray[idx].eventHandler = NULL;
	    thisPtr->eventHandlerArray[idx].userData = 0;
	}
	
	if( VI_TRUE == do_reset ) 
	{
		/* call the reset function to reset the instrument */
		if( age8481a_dcl(*vi)<VI_SUCCESS || age8481a_reset(*vi)< VI_SUCCESS )
		{
			/* ignore any errors in PREFIX_close */
			age8481a_close( *vi);
			*vi=VI_NULL;
			age8481a_LOG_STATUS( *vi, NULL, age8481a_INSTR_ERROR_RESET_FAILED);
		}
		Sleep(100);
	}

	if( VI_TRUE == id_query ) 
	{
		char     idn_buf[256];

		/* find the interface type */
		if( errStatus = viGetAttribute( *vi, VI_ATTR_INTF_TYPE, &intf) )
		{	
			/* Errors: VI_ERROR_NSUP_ATTR */

			/* ignore any errors in PREFIX_close */
			age8481a_close( *vi);
			*vi=VI_NULL;
			age8481a_LOG_STATUS( *vi, NULL, errStatus);
		}

		switch( intf)
		{
			case VI_INTF_GPIB:
				if (viClear(*vi) < VI_SUCCESS ||
				    viPrintf(*vi, "*IDN?\n") < VI_SUCCESS ||
				    viScanf(*vi, "%t", idn_buf) < VI_SUCCESS ||
				    /* check for a idn match */
				    strncmp(idn_buf, age8481a_IDN_STRING, 
					    strlen(age8481a_IDN_STRING))   
				    )
				{   
					/* ignore any errors in PREFIX_close */
					age8481a_close( *vi);
					*vi=VI_NULL;
					age8481a_LOG_STATUS( *vi, NULL,
										 VI_ERROR_FAIL_ID_QUERY);
				}
				break;

			case VI_INTF_VXI:
			case VI_INTF_GPIB_VXI:
	
				/* find the VXI manfacturer's ID */
				errStatus = viGetAttribute( *vi, VI_ATTR_MANF_ID, &manfId);
				if( VI_SUCCESS > errStatus)
				{	
					/* Errors: VI_ERROR_NSUP_ATTR */
	
					/* ignore any errors in PREFIX_close */
					age8481a_close( *vi);
					*vi=VI_NULL;
					age8481a_LOG_STATUS( *vi, NULL, errStatus);
				}

				/* find the instrument's model code */
				errStatus = viGetAttribute( *vi, VI_ATTR_MODEL_CODE, 
										    (ViPAttrState)(&modelCode)); 
				if( VI_SUCCESS > errStatus)
				{	
					/* Errors: VI_ERROR_NSUP_ATTR */
					/* Note: this should never happen 
					 *   with a VXI instrument
					 */
					/* ignore any errors in PREFIX_close */
					age8481a_close( *vi);
					*vi=VI_NULL;
					age8481a_LOG_STATUS( *vi, NULL, errStatus);
				}

				if( (manfId != age8481a_MANF_ID) || 
				    (modelCode != age8481a_MODEL_CODE) )
				{
					/* ignore any errors in PREFIX_close */
					age8481a_close( *vi);
					*vi = VI_NULL;
					age8481a_LOG_STATUS( *vi, NULL, VI_ERROR_FAIL_ID_QUERY);
				}
				break;

			default:
				/* ignore any errors in PREFIX_close */
				age8481a_close( *vi);
				*vi = VI_NULL;
				age8481a_LOG_STATUS( *vi, NULL, age8481a_INSTR_ERROR_UNEXPECTED);
		}	
	} /* if - id_query */
	age8481a_LOG_STATUS( *vi, thisPtr, VI_SUCCESS);
}

/****************************************************************************
age8481a_close
*****************************************************************************
    Parameter Name                                       Type    Direction
   ------------------------------------------------------------------------
  | vi                                                ViSession   IN
  |   ---------------------------------------------------------------------
  |  | Instrument Handle returned from age8481a_init()

*****************************************************************************/

ViStatus _VI_FUNC age8481a_close (INST vi)
{
	ViUInt16 intf;
	struct age8481a_globals *thisPtr;
	ViStatus errStatus;
	ViSession defRM;

	viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
	if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
	{
		errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViPAddr) &thisPtr);
	}
	else
	{
		errStatus = instr_getdata( vi,  (ViPAddr) &thisPtr);
	}
	if( VI_SUCCESS > errStatus)
	{
		/* Errors: VI_ERROR_INV_SESSION	*/
		age8481a_LOG_STATUS( vi, NULL, errStatus);
	}
	age8481a_DEBUG_CHK_THIS( vi, thisPtr);

	/* free memory */
	if( thisPtr)		
	{
		ViStatus e;
	    /* make sure there is something to free */
	    if (thisPtr->e1406)
	    {
			/* retrieve Resource Management session */
			defRM = thisPtr->defRMSession;
			/* close the vi and RM sessions */
			e = viClose( defRM);
			free( thisPtr);
			return e;
	    }
	    else
	    {
			free( thisPtr);
			os_close(vi);
	    }
	}
	else
	{
		os_close(vi);
	}
	return VI_SUCCESS;
}

/****************************************************************************
age8481a_reset
*****************************************************************************
    Parameter Name                                       Type    Direction
   ------------------------------------------------------------------------
  | vi                                                ViSession   IN
  |   ---------------------------------------------------------------------
  |  | Instrument Handle returned from age8481a_init()

*****************************************************************************/

ViStatus _VI_FUNC age8481a_reset (INST vi)
{
	ViUInt16 intf;
	struct age8481a_globals *thisPtr;
	ViStatus errStatus;

	viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
	if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
	{
		errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViPAddr) &thisPtr);
	}
	else
	{
		errStatus = instr_getdata( vi,  (ViPAddr) &thisPtr);
	}
	if( VI_SUCCESS > errStatus)
	{
		/* Errors: VI_ERROR_INV_SESSION	*/
		age8481a_LOG_STATUS( vi, NULL, errStatus);
	}
	age8481a_DEBUG_CHK_THIS( vi, thisPtr);
	age8481a_CDE_INIT( "age8481a_reset");

	if (thisPtr->e1406)
	{
		errStatus = viPrintf( vi, "*RST\n");
	}
	else
	{
		{{ 
//#line 1009 "age8481a.cs"
{extern sw_com_rst();instr_send(vi,sw_com_rst,(void*)0);}}}
	}
	if( VI_SUCCESS > errStatus)
	{
		age8481a_LOG_STATUS( vi, thisPtr, errStatus);
	}
	age8481a_LOG_STATUS( vi, thisPtr, VI_SUCCESS);
}

/****************************************************************************
age8481a_self_test
*****************************************************************************
    Parameter Name                                       Type    Direction
   ------------------------------------------------------------------------
  | vi                                                ViSession   IN
  |   ---------------------------------------------------------------------
  |  | Instrument Handle returned from age8481a_init()
   ------------------------------------------------------------------------
  | test_result                                       ViPInt16    OUT
  |   ---------------------------------------------------------------------
  |  | Numeric result from self-test operation
  |  |
  |  | 0 = no error ( test passed)
  |  | 1 = failure
   ------------------------------------------------------------------------
  | test_message                                      ViChar _VI_FAR []OUT
  |   ---------------------------------------------------------------------
  |  | Self-test status message.  This is limited to 256 characters.

*****************************************************************************/

ViStatus _VI_FUNC age8481a_self_test (INST vi,
									  ViPInt16 test_result,
									  ViChar _VI_FAR test_message[])
{
	ViUInt16 intf;
	struct age8481a_globals *thisPtr;
	ViStatus errStatus;

	/* initialize output parameters */
	*test_result = -1; 
	test_message[0] = 0; 

	viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
	if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
	{
		errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViPAddr) &thisPtr);
	}
	else
	{
		errStatus = instr_getdata( vi,  (ViPAddr) &thisPtr);
	}
	if( VI_SUCCESS > errStatus)
	{
		/* Errors: VI_ERROR_INV_SESSION	*/
		age8481a_LOG_STATUS( vi, NULL, errStatus);
	}
	age8481a_DEBUG_CHK_THIS( vi, thisPtr);
	age8481a_CDE_INIT( "age8481a_self_test");

	if (thisPtr->e1406)
	{
		thisPtr->blockSrqIO = VI_TRUE;

		errStatus = viPrintf( vi, "*TST?\n");
		if( VI_SUCCESS > errStatus)
		{	
			age8481a_LOG_STATUS( vi, thisPtr, errStatus);
		}
		errStatus = viScanf( vi, "%hd%*t", test_result);
	}
	else
	{
		{{ struct {double p1[1];} out_;
//#line 1082 "age8481a.cs"
{extern sw_com_tst_q();if (!instr_query(vi,sw_com_tst_q,(void*)0,&out_)){
//#line 1082 "age8481a.cs"
*test_result=(*(HPSL_INT16*)out_.p1).num;}}}}
	}
	if( VI_SUCCESS > errStatus)
	{
		*test_result = -1; 
		age8481a_LOG_STATUS( vi, thisPtr, errStatus);
	}

	switch(*test_result % 100)
	{
           case 0:
              sprintf(test_message, age8481a_MSG_SELF_TEST_PASSED);
              break;
			  /* from self_test.h in firmware source*/
           case 1:
              sprintf(test_message, "Firmware failed on card %d", 
					  *test_result/100);
              break;
           case 2:
              sprintf(test_message, "Bus error on card %d", 
					  *test_result/100);
              break;
           case 3:
              sprintf(test_message, "Card ID failed on card %d", 
					  *test_result/100);
              break;
           case 4:
              sprintf(test_message, "Bad data on card %d", 
					  *test_result/100);
              break;
           case 5:
              sprintf(test_message, "Bad register values on card %d", 
					  *test_result/100);
              break;
           case 10:
              sprintf(test_message, "Interrupt failed on card %d", 
					  *test_result/100);
              break;
           case 11:
              sprintf(test_message, "Busy timer failed on card %d", 
					  *test_result/100);
              break;
           case 13:
              sprintf(test_message, "Interrupt too soon on card %d", 
					  *test_result/100);
              break;
           case 30:
              sprintf(test_message, "Module ID incorrect on card %d", 
					  *test_result/100);
              break;
           default:
              sprintf(test_message, age8481a_MSG_SELF_TEST_FAILED);
              break;
	}
	age8481a_LOG_STATUS( vi, thisPtr, VI_SUCCESS);
}

/****************************************************************************
age8481a_error_query
*****************************************************************************
    Parameter Name                                       Type    Direction
   ------------------------------------------------------------------------
  | vi                                                ViSession   IN
  |   ---------------------------------------------------------------------
  |  | Instrument Handle returned from age8481a_init()
   ------------------------------------------------------------------------
  | error_number                                      ViPInt32    OUT
  |   ---------------------------------------------------------------------
  |  | Instruments error code
   ------------------------------------------------------------------------
  | error_message                                     ViChar _VI_FAR []OUT
  |   ---------------------------------------------------------------------
  |  | Instrument's error message.  This is limited to 256 characters.

*****************************************************************************/

ViStatus _VI_FUNC age8481a_error_query (INST vi,
										ViPInt32 error_number,
										ViChar _VI_FAR error_message[])
{
	ViUInt16 intf;
	struct age8481a_globals *thisPtr;
	ViStatus errStatus;

	/* initialize output parameters */
	*error_number = -1; 
	error_message[0] = 0; 

	viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
	if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
	{
		errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViPAddr) &thisPtr);
	}
	else
	{
		errStatus = instr_getdata( vi,  (ViPAddr) &thisPtr);
	}
	if( VI_SUCCESS > errStatus)
	{
		/* Errors: VI_ERROR_INV_SESSION	*/
		age8481a_LOG_STATUS( vi, NULL, errStatus);
	}
	age8481a_DEBUG_CHK_THIS( vi, thisPtr);
	age8481a_CDE_INIT( "age8481a_error_query");

	/* error_message[256] = 0; */

	/* get the error number */
	if (thisPtr->e1406)
	{
		thisPtr->blockSrqIO = VI_TRUE;

		errStatus = viPrintf( vi, "SYST:ERR?\n");
		if( VI_SUCCESS > errStatus)
		{
			age8481a_LOG_STATUS( vi, thisPtr, errStatus);
		}

		/* get the error number */
		errStatus = viScanf( vi, "%ld,%t", error_number, error_message);
		/* check for error during the scan */
		if( VI_SUCCESS > errStatus)
		{
			*error_number = -1; 
			error_message[0] = 0; 
			age8481a_LOG_STATUS( vi, thisPtr, errStatus);
		}

		/* get rid of extra LF at the end of the error_message */
		error_message[strlen(error_message)-1] = 0;
	}
	else
	{
        {{ struct {double p1[1];double p2[1];} out_;
//#line 1215 "age8481a.cs"
{extern syst_err_q();if (!instr_query(vi,syst_err_q,(void*)0,&out_)){
//#line 1215 "age8481a.cs"
*error_number=(*(HPSL_INT16*)out_.p1).num;
//#line 1215 "age8481a.cs"
(void)strcpy((error_message),*(HPSL_STRING*)out_.p2);}}}}
	}
	age8481a_LOG_STATUS( vi, thisPtr, VI_SUCCESS);
}

/****************************************************************************
age8481a_error_message
*****************************************************************************
    Parameter Name                                       Type    Direction
   ------------------------------------------------------------------------
  | vi                                                ViSession   IN
  |   ---------------------------------------------------------------------
  |  | Instrument Handle returned from age8481a_init().
  |  | This may be VI_NULL.
   ------------------------------------------------------------------------
  | error_number                                      ViStatus    IN
  |   ---------------------------------------------------------------------
  |  | The error return value from an instrument driver function
   ------------------------------------------------------------------------
  | message                                           ViChar _VI_FAR []OUT
  |   ---------------------------------------------------------------------
  |  | Error message string.  This is limited to 256 characters.

*****************************************************************************/

ViStatus _VI_FUNC age8481a_error_message (INST vi,
										  ViStatus error_number,
										  ViChar _VI_FAR message[])
{
	ViUInt16 intf;
	struct age8481a_globals *thisPtr;
	ViStatus errStatus;  
	ViInt32 idx;

	/* initialize output parameters */
	message[0] = 0;
	thisPtr = NULL;

	/* try to find a thisPtr */
	if( VI_NULL != vi)
	{
		viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
		if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
		{
			errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViPAddr) &thisPtr);
		}
		else
		{
			errStatus = instr_getdata( vi,  (ViPAddr) &thisPtr);
		}
		if( VI_SUCCESS > errStatus)
		{
			/* Errors: VI_ERROR_INV_SESSION	*/
			strcpy( message, age8481a_MSG_INVALID_VI);
			age8481a_LOG_STATUS( vi, NULL, errStatus);
		}
		age8481a_DEBUG_CHK_THIS( vi, thisPtr);
	} 

	if( VI_SUCCESS == error_number)
	{
		sprintf( message, age8481a_MSG_NO_ERRORS);
		age8481a_LOG_STATUS( vi, thisPtr, VI_SUCCESS);
	}

	/* return the static error message */
	for(idx=0; 
	    idx < (sizeof instrErrMsgTable / 
	           sizeof( struct instrErrStruct));
	    idx++)
	{
		/* check for a matching error number */
		if( instrErrMsgTable[idx].errStatus == error_number)
		{
			if( (thisPtr) &&
			    (thisPtr->errNumber == error_number))
			{
				/* context dependent error
				 * message is available.
				 */
				sprintf( message,
				  "%s " age8481a_MSG_IN_FUNCTION " %s() %s",
		          	  instrErrMsgTable[idx].errMessage,
				  thisPtr->errFuncName,
				  thisPtr->errMessage);
			}
			else
			{
				/* No context dependent eror 
				 * message available so copy 
				 * the static error message
				 */
				strcpy( message,
		          	  instrErrMsgTable[idx].errMessage);
			}
			age8481a_LOG_STATUS( vi, thisPtr, VI_SUCCESS);
		}
	}

	/* try VTL/VISA to see if it exists there 
	 *
	 * At this point vi is either VALID or VI_NULL
	 */
	errStatus = viStatusDesc(vi, error_number, message);
	if( VI_SUCCESS == errStatus)
	{
		/* check for a context dependent error message */
		if( (thisPtr) &&
		    (thisPtr->errNumber == error_number))
		{
			/* context dependent error
			 * message is available.
			 */
			strcat( message, " ");
			strcat( message, age8481a_MSG_IN_FUNCTION);
			strcat( message, " ");
			strcat( message, thisPtr->errFuncName);
			strcat( message, "() ");
			strcat( message, thisPtr->errMessage);
		}

		/* VTL found an error message, so return success */
		age8481a_LOG_STATUS( vi, thisPtr, VI_SUCCESS);
	}

	/* if we have a VI_NULL, then we need to return a error message */
	if( VI_NULL == vi)
	{
		strcpy(message, age8481a_MSG_VI_OPEN_ERR);
		age8481a_LOG_STATUS( vi, thisPtr, VI_SUCCESS);
	} 

	/* user passed in a invalid status */
	sprintf( message, 
	  age8481a_MSG_INVALID_STATUS
	  "  %ld"
	  age8481a_MSG_INVALID_STATUS_VALUE
	  , (long)error_number );
	
	age8481a_LOG_STATUS( vi, thisPtr, VI_ERROR_PARAMETER2);
}

/****************************************************************************
age8481a_revision_query
*****************************************************************************
    Parameter Name                                       Type    Direction
   ------------------------------------------------------------------------
  | vi                                                ViSession      IN
  |   ---------------------------------------------------------------------
  |  | Instrument Handle returned from age8481a_init()
   ------------------------------------------------------------------------
  | driver_rev                                ViChar _VI_FAR []      OUT
  |   ---------------------------------------------------------------------
  |  | Instrument driver revision.  This is limited to 256 characters.
   ------------------------------------------------------------------------
  | instr_rev                                 ViChar _VI_FAR []      OUT
  |   ---------------------------------------------------------------------
  |  | Instrument firmware revision.  This is limited to 256 characters.

*****************************************************************************/

ViStatus _VI_FUNC age8481a_revision_query (INST vi,
										   ViChar _VI_FAR driver_rev[],
										   ViChar _VI_FAR instr_rev[])
{
	ViUInt16 intf;
	struct age8481a_globals *thisPtr;
	ViStatus errStatus;
	char temp_str[256];		/* temp hold for instr rev string */
	char *last_comma;		/* last comma in *IDN string */

	/* initialize output parameters */
	driver_rev[0] = 0; 
	instr_rev[0] = 0; 

	viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
	if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
	{
		errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViPAddr) &thisPtr);
	}
	else
	{
		errStatus = instr_getdata( vi,  (ViPAddr) &thisPtr);
	}
	if( VI_SUCCESS > errStatus)
	{
		/* Errors: VI_ERROR_INV_SESSION	*/
		age8481a_LOG_STATUS( vi, NULL, errStatus);
	}
	age8481a_DEBUG_CHK_THIS( vi, thisPtr);
	age8481a_CDE_INIT( "age8481a_revision_query");

	sprintf( driver_rev, "%s", age8481a_REV_CODE);
	if (thisPtr->e1406)
	{
		thisPtr->blockSrqIO = VI_TRUE;

		if( errStatus = viPrintf( vi, "*IDN?\n"))
		{
			driver_rev[0] = 0; 
			age8481a_LOG_STATUS( vi, thisPtr, errStatus); 
		}

		if( errStatus = viScanf( vi, "%s%*t", temp_str))
		{
			driver_rev[0] = 0; 
			instr_rev[0] = 0; 
		 
			age8481a_LOG_STATUS( vi, thisPtr, errStatus); 
		}
	}
	else
	{
		{{ struct {double p1[1];} out_;
//#line 1428 "age8481a.cs"
{extern com_idn_q();if (!instr_query(vi,com_idn_q,(void*)0,&out_)){
//#line 1428 "age8481a.cs"
(void)memcpy((temp_str),(*(HPSL_ARB_ASCII*)out_.p1).buffer,(*(HPSL_ARB_ASCII*)out_.p1).length);
//#line 1428 "age8481a.cs"
(temp_str)[(*(HPSL_ARB_ASCII*)out_.p1).length]='\0';}}}}
	}

	last_comma = strrchr(temp_str,',');
	/* error and exit if last comma not found */
	if (!last_comma) 
	{
		instr_rev[0] = 0;
		age8481a_CDE_MESSAGE("no last comma found in IDN string" ); 
		age8481a_LOG_STATUS( vi, thisPtr, age8481a_INSTR_ERROR_UNEXPECTED); 
	}
	strcpy(instr_rev, last_comma+1);
	age8481a_LOG_STATUS( vi, thisPtr, VI_SUCCESS); 
}

/****************************************************************************
age8481a_timeOut
*****************************************************************************
    Parameter Name                                       Type    Direction
   ------------------------------------------------------------------------
  | vi                                                ViSession   IN
  |   ---------------------------------------------------------------------
  |  | Instrument Handle returned from age8481a_init()
   ------------------------------------------------------------------------
  | timeOut                                           ViInt32     IN
  |   ---------------------------------------------------------------------
  |  | This value sets the I/O timeout for all functions in
  |  | the driver. It is specified in milliseconds.

*****************************************************************************/
/* ----------------------------------------------------------------------- */
/* Purpose:  Changes the timeout value of the instrument.  Input is in     */
/*           milliseconds.                                                 */
/* ----------------------------------------------------------------------- */

ViStatus _VI_FUNC age8481a_timeOut (INST vi,
									ViInt32 timeOut)
{
	ViUInt16 intf;
	ViStatus errStatus = 0;
	struct age8481a_globals *thisPtr;

	viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
	if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
	{
		errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViPAddr) &thisPtr);
	}
	else
	{
		errStatus = instr_getdata( vi,  (ViPAddr) &thisPtr);
	}
	if( VI_SUCCESS > errStatus)
	{
		/* Errors: VI_ERROR_INV_SESSION	*/
		age8481a_LOG_STATUS( vi, NULL, errStatus);
	}
	age8481a_DEBUG_CHK_THIS( vi, thisPtr );
	age8481a_CDE_INIT( "age8481a_timeOut" );

	age8481a_CHK_LONG_RANGE( timeOut, 1, 2147483647, VI_ERROR_PARAMETER2 );

	if (thisPtr->e1406)
	{
		errStatus = viSetAttribute(vi, VI_ATTR_TMO_VALUE, timeOut);
	}
	else
	{
		errStatus = instr_settimeout(vi, timeOut);
	}
	if ( VI_SUCCESS > errStatus)
	{
		age8481a_LOG_STATUS( vi, thisPtr, errStatus );
	}
	age8481a_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/****************************************************************************
age8481a_timeOut_Q
*****************************************************************************
    Parameter Name                                       Type    Direction
   ------------------------------------------------------------------------
  | vi                                                ViSession   IN
  |   ---------------------------------------------------------------------
  |  | Instrument Handle returned from age8481a_init()
   ------------------------------------------------------------------------
  | pTimeOut                                          ViPInt32    OUT
  |   ---------------------------------------------------------------------
  |  | This is the minimum timeout period that the driver
  |  | can be set to. It is specified in milliseconds.

*****************************************************************************/
/* ----------------------------------------------------------------------- */
/* Purpose:  Returns the current setting of the timeout value of the       */
/*           instrument in milliseconds.                                   */
/* ----------------------------------------------------------------------- */

ViStatus _VI_FUNC age8481a_timeOut_Q (INST vi,
									  ViPInt32 timeOut)
{
	ViUInt16 intf;
	ViStatus errStatus = 0;
	struct age8481a_globals *thisPtr;

	viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
	if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
	{
		errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViPAddr) &thisPtr);
	}
	else
	{
		errStatus = instr_getdata( vi,  (ViPAddr) &thisPtr);
	}
	if( VI_SUCCESS > errStatus)
	{
		age8481a_LOG_STATUS( vi, NULL, errStatus );
	}
	age8481a_DEBUG_CHK_THIS( vi, thisPtr );
	age8481a_CDE_INIT( "age8481a_timeOut_Q" );

	if (thisPtr->e1406)
	{
		errStatus = viGetAttribute(vi, VI_ATTR_TMO_VALUE, timeOut );
	}
	else
	{
		errStatus = instr_gettimeout(vi, timeOut );
	}
	if( VI_SUCCESS > errStatus)
	{
		age8481a_LOG_STATUS( vi, thisPtr, errStatus );
	}

	age8481a_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/****************************************************************************
age8481a_errorQueryDetect
*****************************************************************************
    Parameter Name                                       Type    Direction
   ------------------------------------------------------------------------
  | vi                                                ViSession   IN
  |   ---------------------------------------------------------------------
  |  | Instrument Handle returned from age8481a_init()
   ------------------------------------------------------------------------
  | errorQueryDetect                                  ViBoolean   IN
  |   ---------------------------------------------------------------------
  |  | Boolean which enables (VI_TRUE) or disables (VI_FALSE)
  |  | automatic instrument error querying.

*****************************************************************************/

ViStatus _VI_FUNC age8481a_errorQueryDetect(INST vi,
											ViBoolean errDetect)
{
	ViUInt16 intf;
	ViStatus errStatus = 0;
	struct age8481a_globals *thisPtr;

	viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
	if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
	{
		errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViPAddr) &thisPtr);
	}
	else
	{
		errStatus = instr_getdata( vi,  (ViPAddr) &thisPtr);
	}
	if( VI_SUCCESS > errStatus ) 
	{ 
		age8481a_LOG_STATUS( vi, NULL, errStatus ); 
	}

	age8481a_DEBUG_CHK_THIS( vi, thisPtr );
	age8481a_CDE_INIT( "age8481a_errorQueryDetect" );
	age8481a_CHK_BOOLEAN( errDetect, VI_ERROR_PARAMETER2 );

	thisPtr->errQueryDetect = errDetect;

	age8481a_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/****************************************************************************
age8481a_errorQueryDetect_Q
*****************************************************************************
    Parameter Name                                       Type    Direction
   ------------------------------------------------------------------------
  | vi                                                ViSession   IN
  |   ---------------------------------------------------------------------
  |  | Instrument Handle returned from age8481a_init()
   ------------------------------------------------------------------------
  | pErrDetect                                        ViPBoolean  OUT
  |   ---------------------------------------------------------------------
  |  | Boolean indicating if automatic instrument error
  |  | querying is performed.

*****************************************************************************/

ViStatus _VI_FUNC age8481a_errorQueryDetect_Q(INST vi,
											  ViPBoolean pErrDetect)
{
	ViUInt16 intf;
	ViStatus errStatus = 0;
	struct age8481a_globals *thisPtr;

	viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
	if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
	{
		errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViPAddr) &thisPtr);
	}
	else
	{
		errStatus = instr_getdata( vi,  (ViPAddr) &thisPtr);
	}
	if( VI_SUCCESS > errStatus ) 
	{ 
		age8481a_LOG_STATUS( vi, NULL, errStatus ); 
	}

	age8481a_DEBUG_CHK_THIS( vi, thisPtr );
	age8481a_CDE_INIT( "age8481a_errorQueryDetect_Q" );

	*pErrDetect = thisPtr->errQueryDetect;

	age8481a_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/****************************************************************************
age8481a_dcl
*****************************************************************************
    Parameter Name                                       Type    Direction
   ------------------------------------------------------------------------
  | vi                                                ViSession   IN
  |   ---------------------------------------------------------------------
  |  | Instrument Handle returned from age8481a_init()

*****************************************************************************/

ViStatus _VI_FUNC age8481a_dcl(INST vi)
{
	ViUInt16 intf;
	ViStatus errStatus = 0;
	struct age8481a_globals *thisPtr;

	viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
	if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
	{
		errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViPAddr) &thisPtr);
	}
	else
	{
		errStatus = instr_getdata( vi,  (ViPAddr) &thisPtr);
	}
	if( VI_SUCCESS > errStatus ) 
	{ 
		age8481a_LOG_STATUS( vi, NULL, errStatus ); 
	}

	age8481a_DEBUG_CHK_THIS( vi, thisPtr );
	age8481a_CDE_INIT( "age8481a_dcl" );

	if (thisPtr->e1406)
	{
		errStatus = viClear(vi);
		if( VI_SUCCESS > errStatus)
		{
			age8481a_LOG_STATUS( vi, thisPtr, errStatus );
		}
	}
	else
	{
		{extern switch_hpsl_dcas();instr_clear(vi,switch_hpsl_dcas);}
	}
	age8481a_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/****************************************************************************
age8481a_opc
*****************************************************************************
    Parameter Name                                       Type    Direction
   ------------------------------------------------------------------------
  | vi                                                ViSession   IN
  |   ---------------------------------------------------------------------
  |  | Instrument Handle returned from age8481a_init()

*****************************************************************************/

ViStatus _VI_FUNC age8481a_opc (INST vi)
{
	ViUInt16 intf;
	ViStatus errStatus = 0;
	struct age8481a_globals *thisPtr;

	viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
	if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
	{
		errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViPAddr) &thisPtr);
	}
	else
	{
		errStatus = instr_getdata( vi,  (ViPAddr) &thisPtr);
	}
	if( VI_SUCCESS > errStatus)
	{
		age8481a_LOG_STATUS(vi, NULL, errStatus );
	}
	age8481a_DEBUG_CHK_THIS( vi, thisPtr );
	age8481a_CDE_INIT( "age8481a_opc" );

	if (thisPtr->e1406)
	{
		errStatus = viPrintf(vi,"*OPC\n");
		if( VI_SUCCESS > errStatus)
		{
			age8481a_LOG_STATUS(vi, thisPtr, errStatus );
		}
	}
	else   
	{
		{{ 
//#line 1746 "age8481a.cs"
{extern sw_com_opc();instr_send(vi,sw_com_opc,(void*)0);}}}
	}
	age8481a_LOG_STATUS(vi, thisPtr, VI_SUCCESS );
}

/****************************************************************************
age8481a_opc_Q
*****************************************************************************
    Parameter Name                                       Type    Direction
   ------------------------------------------------------------------------
  | vi                                                ViSession   IN
  |   ---------------------------------------------------------------------
  |  | Instrument Handle returned from age8481a_init()
   ------------------------------------------------------------------------
  | opc                                               ViPInt16    OUT
  |   ---------------------------------------------------------------------
  |  | returns a 1 when all pending instruments commands are completed

*****************************************************************************/

ViStatus _VI_FUNC age8481a_opc_Q (INST vi,
								  ViPInt16 opc)
{
	ViUInt16 intf;
	ViStatus errStatus = 0;
	struct age8481a_globals *thisPtr;

	viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
	if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
	{
		errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViPAddr) &thisPtr);
	}
	else
	{
		errStatus = instr_getdata( vi,  (ViPAddr) &thisPtr);
	}
	if( VI_SUCCESS > errStatus)
	{
		age8481a_LOG_STATUS(vi, NULL, errStatus );
	}
	age8481a_DEBUG_CHK_THIS( vi, thisPtr );
	age8481a_CDE_INIT( "age8481a_opc_Q" );
 
	if (thisPtr->e1406)
	{
		thisPtr->blockSrqIO = VI_TRUE;

		errStatus = viPrintf(vi,"*OPC?\n");
		if( VI_SUCCESS > errStatus)
		{
			age8481a_LOG_STATUS(vi, thisPtr, errStatus );
		}

		errStatus = viScanf(vi, "%hd%*t", opc);
		if( VI_SUCCESS > errStatus)
		{
			age8481a_LOG_STATUS(vi, thisPtr, errStatus );
		}
	}
	else
	{
		{{ struct {double p1[1];} out_;
//#line 1807 "age8481a.cs"
{extern sw_com_opc_q();if (!instr_query(vi,sw_com_opc_q,(void*)0,&out_)){
//#line 1807 "age8481a.cs"
*opc=1;}}}}
	}
	age8481a_LOG_STATUS(vi, thisPtr, VI_SUCCESS );
}

/****************************************************************************
age8481a_wai
*****************************************************************************
    Parameter Name                                       Type    Direction
   ------------------------------------------------------------------------
  | vi                                                ViSession   IN
  |   ---------------------------------------------------------------------
  |  | Instrument Handle returned from age8481a_init()

*****************************************************************************/

ViStatus _VI_FUNC age8481a_wai (INST vi)
{
	ViUInt16 intf;
	ViStatus errStatus = 0;
	struct age8481a_globals *thisPtr;

	viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
	if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
	{
		errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViPAddr) &thisPtr);
	}
	else
	{
		errStatus = instr_getdata( vi,  (ViPAddr) &thisPtr);
	}
	if ( VI_SUCCESS > errStatus)
	{
		age8481a_LOG_STATUS(vi, NULL, errStatus );
	}
	age8481a_DEBUG_CHK_THIS( vi, thisPtr );
	age8481a_CDE_INIT( "age8481a_wai" );

	if (thisPtr->e1406)
	{
		errStatus = viPrintf(vi,"*WAI\n");
		if (VI_SUCCESS > errStatus)
		{
			age8481a_LOG_STATUS(vi, thisPtr, errStatus );
		}
	}
	else
	{
		{{ 
//#line 1855 "age8481a.cs"
{extern sw_com_wai();instr_send(vi,sw_com_wai,(void*)0);}}}
	}
	age8481a_LOG_STATUS(vi, thisPtr, VI_SUCCESS );
}

/****************************************************************************
age8481a_trg
*****************************************************************************
    Parameter Name                                       Type    Direction
   ------------------------------------------------------------------------
  | vi                                                ViSession   IN
  |   ---------------------------------------------------------------------
  |  | Instrument Handle returned from age8481a_init()

*****************************************************************************/

ViStatus _VI_FUNC age8481a_trg (INST vi)
{
	ViUInt16 intf;
	ViStatus errStatus = 0;
	struct age8481a_globals *thisPtr;

	viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
	if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
	{
		errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViPAddr) &thisPtr);
	}
	else
	{
		errStatus = instr_getdata( vi,  (ViPAddr) &thisPtr);
	}
	if ( VI_SUCCESS > errStatus)
	{
		age8481a_LOG_STATUS(vi, NULL, errStatus );
	}
	age8481a_DEBUG_CHK_THIS( vi, thisPtr );
	age8481a_CDE_INIT( "age8481a_trg" );

	if (thisPtr->e1406)
	{
		errStatus = viPrintf(vi,"*TRG\n");
		if ( VI_SUCCESS > errStatus)
		{
			age8481a_LOG_STATUS(vi, thisPtr, errStatus );
		}
	}
	else
	{
		{{ 
//#line 1903 "age8481a.cs"
{extern sw_special_trig();instr_send(vi,sw_special_trig,(void*)0);}}}
	}
	age8481a_LOG_STATUS(vi, thisPtr, VI_SUCCESS );
}

/****************************************************************************
age8481a_readStatusByte_Q
*****************************************************************************
    Parameter Name                                       Type    Direction
   ------------------------------------------------------------------------
  | vi                                                ViSession   IN
  |   ---------------------------------------------------------------------
  |  | Instrument Handle returned from age8481a_init()
   ------------------------------------------------------------------------
  | statusByte                                        ViPInt16    OUT
  |   ---------------------------------------------------------------------
  |  | returns the contents of the status byte

*****************************************************************************/

ViStatus _VI_FUNC age8481a_readStatusByte_Q(INST vi,
											ViPInt16 statusByte)
{
	ViUInt16 intf;
	ViStatus errStatus = 0;
	struct age8481a_globals *thisPtr;
	ViUInt16 stb;

	viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
	if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
	{
		errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViPAddr) &thisPtr);
	}
	else
	{
		errStatus = instr_getdata( vi,  (ViPAddr) &thisPtr);
	}
	if ( VI_SUCCESS > errStatus)
	{
		age8481a_LOG_STATUS(vi, NULL, errStatus );
	}
	age8481a_DEBUG_CHK_THIS( vi, thisPtr );
	age8481a_CDE_INIT( "age8481a_readStatusByte_Q" );

	if (thisPtr->e1406)
	{
		errStatus = viReadSTB(vi,&stb);
		if( VI_SUCCESS > errStatus)
		{
			age8481a_LOG_STATUS(vi, thisPtr, errStatus );
		}
	}
	else
	{
		instr_poll(vi,&stb);
	}

	*statusByte = (ViInt16)stb;
	age8481a_LOG_STATUS(vi, thisPtr, VI_SUCCESS );
}

ViInt32 age8481a_statusHap[age8481a_MAX_STAT_HAP] = {
	age8481a_USER_ERROR_HANDLER,
	age8481a_ESR_OPC,
	age8481a_ESR_QUERY_ERROR,
	age8481a_ESR_DEVICE_DEPENDENT_ERROR,
	age8481a_ESR_EXECUTION_ERROR,
	age8481a_ESR_COMMAND_ERROR,
	age8481a_OPER_SCAN_DONE
};

/* Assumes we have driver copies of the event register.  This is needed
 * because in IEEE 488.2, the event register are cleared after they are 
 * read.  Since the event register contains several events, we need to
 * keep this information around to pass back to the user.
 */

struct age8481a_statusAccess {
	ViInt32 registerIdx; 
	ViString condQry;
	ViString eventQry;
	ViString enableCmd;
};

const struct age8481a_statusAccess age8481a_accessInfo[age8481a_MAX_STAT_REG] = {
	{0, 	"",	 		"*STB?",		"*SRE"},
	{400, 	"STAT:QUES:COND?",	"STAT:QUES:EVEN?",	"STAT:QUES:ENAB"},
	{600,	"",			"*ESR?",			"*ESE"},
	{800, 	"STAT:OPER:COND?",	"STAT:OPER:EVEN?",	"STAT:OPER:ENAB"}
};

/* this will return the index associated with the happening */
ViBoolean age8481a_findHappeningIdx(ViInt32 happening,
									ViPInt32 pIdx)
{
	/* Note: this is a linear search, for faster access this
	 * could be done as a binary search since the data is arrange
	 * in order numerically.
	 */
	for( *pIdx=0; *pIdx<age8481a_MAX_STAT_HAP; *pIdx = *pIdx + 1)
	{
		if( age8481a_statusHap[*pIdx] == happening)
		{
			return VI_TRUE;
		}	
	}
	return VI_FALSE;
}

/* this will return the index that corresponds with regNum */
static ViBoolean age8481a_findAccessIdx(ViInt32 regNum,
										ViPInt32 pIdx )
{
	for(*pIdx=0; *pIdx<age8481a_MAX_STAT_REG; *pIdx = *pIdx + 1)
	{
		if( regNum == age8481a_accessInfo[*pIdx].registerIdx)
		{	
			return VI_TRUE;
		}
	}
	return VI_FALSE;
}

static ViStatus age8481a_readAllEvents(INST vi)
{
	ViUInt16 intf;
	ViInt32 idx;
	ViStatus errStatus;
	ViInt32 eventResp;
	struct age8481a_globals *thisPtr;
	
	viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
	if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
	{
		errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViPAddr) &thisPtr);
	}
	else
	{
		errStatus = instr_getdata( vi,  (ViPAddr) &thisPtr);
	}
   	if( VI_SUCCESS > errStatus) 
   	{
   	   age8481a_LOG_STATUS( vi, NULL, errStatus );
   	}
   	age8481a_DEBUG_CHK_THIS( vi, thisPtr );
        
	/* read all events and update driver events */
	for(idx=0; idx<age8481a_MAX_STAT_REG; idx++)
	{
		/* if there is an event query */
		if( 0 != strlen(age8481a_accessInfo[idx].eventQry))
		{
			/* okay - query the instrument for event */
			if (thisPtr->e1406)
			{
				thisPtr->blockSrqIO = VI_TRUE;

				errStatus = viPrintf(vi,
				  "%s\n", age8481a_accessInfo[idx].eventQry);
				if( VI_SUCCESS > errStatus)
				{
					return errStatus;
				}

				/* get the response */
				errStatus = viScanf(vi, "%ld%*t", &eventResp);
				if( VI_SUCCESS > errStatus )
				{
					return errStatus;
				}
			}
			else
			{
				ViChar resp_str[100];

				cscpi_exe(vi, age8481a_accessInfo[idx].eventQry,
						  strlen(age8481a_accessInfo[idx].eventQry),
						  resp_str, sizeof(resp_str));
				/* get the response */
				eventResp = atol(resp_str);
			}

			/* update the driver events copy of instr events */
			thisPtr->driverEventArray[idx] = 	
			  thisPtr->driverEventArray[idx] | eventResp;
		} /* if - an event query exists */
	} /* for - all status registers */
	return VI_SUCCESS;
} /* age8481a_readAllEvents() */

/* this recursive routine traverse the IEEE 488.2 status structures and
 * processes events.
 */
static void age8481a_srqTraverse(INST vi,
								 ViInt32 eventReg)
{
	ViUInt16 intf;
	struct age8481a_globals *thisPtr;
	ViInt32 accessIdx;
	ViInt32 hapIdx;
	ViUInt16 Status;
	ViInt32 eventVal;
	ViInt32 happening;
	ViInt32 bitPos;
	ViStatus errStatus;

	viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
	if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
	{
		errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViPAddr) &thisPtr);
	}
	else
	{
		errStatus = instr_getdata( vi,  (ViPAddr) &thisPtr);
	}
   	if( VI_SUCCESS > errStatus) 
	{
		/* error couldn't get attribute */
		return;  
	}

	if( VI_FALSE == age8481a_findAccessIdx( eventReg, &accessIdx))
	{
		/* couldn't find register num 
		 *   don't know what to do so leave 
		 */
		return;
	}

	if( 0 == eventReg )
	{
		/* need to read status byte through VTL instead of SCPI */
		if (thisPtr->e1406)
		{
			if( viReadSTB( vi, &Status))
			{
				/* an error occured */
				return;
			}
		}
		else
		{
			instr_poll(vi,&Status);
		}
		eventVal = (ViInt32)Status;
	}
	else
	{
		/* find the event in the table */
		if( 0 != strlen(age8481a_accessInfo[accessIdx].eventQry))
		{
			/* query instrument to find what event(s) occured. */
			if (thisPtr->e1406)
			{
				if( viPrintf(vi,"%s\n",
					 age8481a_accessInfo[accessIdx].eventQry))
				{
					/* an error occured */
					return;
				}

				if( viScanf(vi,"%ld%*t\n", &eventVal)) 
				{
					/* an error occured */
					return;
				}
			}
			else
			{
				ViChar resp_str[100];

				cscpi_exe(vi,
					  age8481a_accessInfo[accessIdx].eventQry,
					  strlen(age8481a_accessInfo[accessIdx].eventQry),
					  resp_str,
					  sizeof(resp_str)
					  );
				/* get the response */
				eventVal = atol(resp_str);
			}
		}
		else
		{
			/* error - no events for this status register */
			return;
		}
	} /* else - not status byte */

	/* update driver events */
	thisPtr->driverEventArray[accessIdx] = 
	  thisPtr->driverEventArray[accessIdx] | eventVal;

	for( bitPos = 0; bitPos < 16; bitPos++)
	{
		/* check for an event occurance */
		if( eventVal & (1 << bitPos) )
		{
			/* find happening index */
			happening = eventReg + bitPos + 1;
			if( VI_TRUE == 
			       age8481a_findHappeningIdx( happening, &hapIdx) )
			{
				/* does event have a handler enabled? */
				if( thisPtr->eventHandlerArray[hapIdx].eventHandler)
				{
					/* call the users handler */
			    	thisPtr->eventHandlerArray[hapIdx].eventHandler(
			    	  vi, happening, 
			    	  thisPtr->eventHandlerArray[hapIdx].userData);
				}				
			}

		} /* if - event occured */

		/* check for more status registers */
		if( VI_TRUE == age8481a_findAccessIdx( happening*100, &accessIdx))
		{
			/* need to traverse these other registers */
			age8481a_srqTraverse( vi, happening*100);
		}

	} /* for - all bits in the event */
}

/* this is the SRQ event handler for hpib*/
ViStatus _VI_FUNCH age8481a_srqHdlr(INST vi,
									ViEventType eventType,
									ViEvent event,
									ViAddr userData)
{
	/* the only reason we should get called is for a Service Request */	

	/* for VTL 3.0 we always need to return VI_SUCCESS, therefore
	 * we will ignore any VTL errors at this level.
	 */

	struct age8481a_globals *thisPtr;

	if(VI_SUCCESS > 
	   viGetAttribute( vi, VI_ATTR_USER_DATA, (ViPAddr) &thisPtr) )
	{
		/* error couldn't get attribute, 
		 * but we lie and return VI_SUCCESS */
		return VI_SUCCESS;  
	}

	/* check if it is okay to do I/O in SRQ handler */
	if( VI_TRUE == thisPtr->blockSrqIO)
	{
	    /* not okay to do I/O so just update srq count */
	    thisPtr->countSrqIO = thisPtr->countSrqIO + 1;
		return VI_SUCCESS;  
	}

	/* suspend event processing for now */
	viEnableEvent( vi, VI_EVENT_SERVICE_REQ, VI_SUSPEND_HNDLR, VI_NULL);

	/* recursively traverse status byte */
	age8481a_srqTraverse( vi, 0);

	/* re-enable event processing */
	viEnableEvent( vi, VI_EVENT_SERVICE_REQ, VI_HNDLR, VI_NULL);

	/* always return VI_SUCCESS */
	return VI_SUCCESS;
} 

/* this is the simulated SRQ event handler for register based*/
ViStatus _VI_FUNCH age8481a_rb_srqHdlr(INST vi,
									   ViEventType eventType,
									   ViEvent event,
									   ViAddr userData)
{
	age8481a_srqTraverse( vi, 0);
	return VI_SUCCESS;
} 

/****************************************************************************
age8481a_statEven_Q
*****************************************************************************
    Parameter Name                                       Type    Direction
   ------------------------------------------------------------------------
  | vi                                                ViSession   IN
  |   ---------------------------------------------------------------------
  |  | Instrument Handle returned from age8481a_init()
   ------------------------------------------------------------------------
  | happening                                         ViInt32     IN
  |   ---------------------------------------------------------------------
  |  | Happenings refer to something that happens. These can refer
  |  | to conditions or events. All of the conditions listed in the
  |  | age8481a_statCond_Q() function will be detected as events as
  |  | well.   An event may be registered when a condition changes
  |  | state from  VI_FALSE to VI_TRUE.
  |  |
   ------------------------------------------------------------------------
  | pEvent                                            ViPBoolean  OUT
  |   ---------------------------------------------------------------------
  |  | VI_TRUE  = event occured sometime between event readings
  |  | VI_FALSE = the event did not occur between event readings

*****************************************************************************/

ViStatus _VI_FUNC age8481a_statEven_Q(INST vi,
									  ViInt32	happening,
									  ViPBoolean	pEvent)
{
	ViUInt16 intf;
	struct age8481a_globals *thisPtr;
	ViStatus errStatus;
	ViInt32 hapIdx;
	ViInt32 accessIdx;
	ViInt32 event_q;
	ViInt32 regNum;
	ViInt32 bitNum;
	ViInt32 mask;
	char errMsg[256];

	/* initialize output parameters */
	*pEvent = VI_FALSE;

	viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
	if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
	{
		errStatus = viGetAttribute( vi, VI_ATTR_USER_DATA, (ViPAddr) &thisPtr);
	}
	else
	{
		errStatus = instr_getdata( vi,  (ViPAddr) &thisPtr);
	}
	if( VI_SUCCESS > errStatus)
	{
		/* Errors: VI_ERROR_INV_SESSION */
		age8481a_LOG_STATUS( vi, NULL, errStatus);
	}
	age8481a_DEBUG_CHK_THIS( vi, thisPtr);
	age8481a_CDE_INIT( "age8481a_statEven_Q");

	/* check validity of happening */
	if( (age8481a_USER_ERROR_HANDLER == happening) ||
            (VI_FALSE == age8481a_findHappeningIdx( happening, &hapIdx) ))
	{
		sprintf(errMsg,"%hd " age8481a_MSG_INVALID_HAPPENING, happening);
		age8481a_CDE_MESSAGE( errMsg);
		
		age8481a_LOG_STATUS( vi, thisPtr, VI_ERROR_PARAMETER2);
	}

	regNum = happening / 100;
	bitNum = happening % 100;

	/* get access index */
	if( VI_FALSE == age8481a_findAccessIdx( regNum * 100, &accessIdx))
	{
		
		age8481a_LOG_STATUS( vi, thisPtr, age8481a_INSTR_ERROR_UNEXPECTED);
	}

	/* see if we can query the event from the instrument */
	if( 0 == strlen(age8481a_accessInfo[accessIdx].eventQry))
	{
		char errMsg[256];

		/* unable to query the event */
		sprintf(errMsg, age8481a_MSG_EVENT
		  "%hd" age8481a_MSG_NOT_QUERIABLE, happening);
		age8481a_CDE_MESSAGE(errMsg); 
		
		age8481a_LOG_STATUS( vi, thisPtr, VI_ERROR_PARAMETER2);
	}
	else
	{
		/* okay - query the instrument for event */
		if (thisPtr->e1406)
		{
			thisPtr->blockSrqIO = VI_TRUE;

			errStatus = viPrintf(vi,
			  "%s\n", age8481a_accessInfo[accessIdx].eventQry);
			if( 0 > errStatus)
			{
				age8481a_LOG_STATUS( vi, thisPtr, errStatus);
			}

			/* get the response */
			errStatus = viScanf(vi, "%ld%*t", &event_q);
			if( 0 > errStatus )
			{
				age8481a_LOG_STATUS( vi, thisPtr, errStatus);
			}
		}
		else
		{
			ViChar resp_str[100];

			cscpi_exe(vi, age8481a_accessInfo[accessIdx].eventQry,
					  strlen(age8481a_accessInfo[accessIdx].eventQry),
					  resp_str, sizeof(resp_str));
			/* get the response */
			event_q = atol(resp_str);
		}

		/* update the driver events copy of instrument events */
		thisPtr->driverEventArray[accessIdx] = 	
		  thisPtr->driverEventArray[accessIdx] | event_q;

		/* check state of event bit */
		mask = 1 << (bitNum -1);
		if( thisPtr->driverEventArray[accessIdx] & mask )
		{
			*pEvent = VI_TRUE;

			/* clear event bit in driver events */
			thisPtr->driverEventArray[accessIdx] = 	
		 	  thisPtr->driverEventArray[accessIdx] & (~mask);
		}
		else
		{
			*pEvent = VI_FALSE;

			/* event bit in driver event array
			 * is already cleared 
			 */
		}
	}
	age8481a_LOG_STATUS( vi, thisPtr, VI_SUCCESS);
}	

/****************************************************************************
age8481a_statEvenHdlr
*****************************************************************************
    Parameter Name                                       Type    Direction
   ------------------------------------------------------------------------
  | vi                                                ViSession   IN
  |   ---------------------------------------------------------------------
  |  | Instrument Handle returned from age8481a_init()
   ------------------------------------------------------------------------
  | happening                                         ViInt32     IN
  |   ---------------------------------------------------------------------
  |  | Happenings refer to something that happens. These can refer to
  |  | conditions or events. Happenings are enumerated as ViInt32
  |  | numbers.  Only events can have happenings associated with it.
  |  |
   ------------------------------------------------------------------------
  | eventHandler                           age8481a_InstrEventHandler  IN
  |   ---------------------------------------------------------------------
  |  | This is either NULL or a pointer to the user specified
  |  | event handler.  A NULL disables the event handler.
  |  |
  |  | An event handler has the following prototype:
  |  |
  |  | typedef void (_VI_FUNCH _VI_PTR  age8481a_InstrEventHandler)(
  |  | ViSession vi,
  |  | ViInt32 happening,
  |  | ViAddr userData
  |  | );
   ------------------------------------------------------------------------
  | userData                                          ViAddr      IN
  |   ---------------------------------------------------------------------
  |  | This is a pointer that is passed to the handler when the
  |  | specified event occurs.  This can be used by the programmer
  |  | to pass additional information to the handler.

*****************************************************************************/

ViStatus _VI_FUNC age8481a_statEvenHdlr(INST vi,
										ViInt32 happening,
										age8481a_InstrEventHandler eventHandler,
										ViAddr userData)
{
	ViUInt16 intf;
	struct age8481a_globals *thisPtr;
	ViStatus errStatus;
	ViInt32 hapIdx;
	ViInt32 accessIdx;
	ViInt32 propagate;
	ViInt32 regNum;
	ViInt32 bitNum;
	ViInt32 enableMask;
	char errMsg[80];

	/* initialize output parameters */

	viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
	if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
	{
		errStatus = viGetAttribute(
				vi, VI_ATTR_USER_DATA, (ViPAddr) &thisPtr);
	}
	else
	{
		errStatus = instr_getdata( vi,  (ViPAddr) &thisPtr);
	}
	if( VI_SUCCESS > errStatus)
	{
		/* Errors: VI_ERROR_INV_SESSION */
		age8481a_LOG_STATUS( vi, NULL, errStatus);
	}
	age8481a_DEBUG_CHK_THIS( vi, thisPtr);
	age8481a_CDE_INIT( "age8481a_statEvenHdlr");

	if( age8481a_USER_ERROR_HANDLER == happening)
	{
		/* store handler and user data */
		thisPtr->eventHandlerArray[
                   age8481a_USER_ERROR_HANDLER_IDX].eventHandler = eventHandler;
		thisPtr->eventHandlerArray[
                   age8481a_USER_ERROR_HANDLER_IDX].userData = userData;
		age8481a_LOG_STATUS( vi, thisPtr, VI_SUCCESS);
	}

	/* check validity of happening */
	if( VI_FALSE == age8481a_findHappeningIdx( happening, &hapIdx) )
	{

		sprintf(errMsg,"%ld " age8481a_MSG_INVALID_HAPPENING, 
		  (long)happening);
		age8481a_CDE_MESSAGE( errMsg);
		
		age8481a_LOG_STATUS( vi, thisPtr, VI_ERROR_PARAMETER2);
	}

	regNum = happening / 100;
	bitNum = happening % 100;

	/* suspend SRQ events - if handler is installed */
	if( thisPtr->e1406 && 0 > thisPtr->numEventHandlers)
	{
		errStatus = viEnableEvent( vi,VI_EVENT_SERVICE_REQ ,
		  VI_SUSPEND_HNDLR, VI_NULL);
		if( errStatus)
		{
			age8481a_LOG_STATUS( vi, thisPtr, errStatus);
		}
	}	

	/* see if we want to enable or disable the handler */
	if( NULL != eventHandler)
	{
		/* see if event handler already exists */		
		if( NULL == thisPtr->eventHandlerArray[hapIdx].eventHandler )
		{
			/* okay - no event handler */
			thisPtr->numEventHandlers =
			  thisPtr->numEventHandlers + 1;
		}
		else
		{
			/* reenable SRQ events - if handler is installed */
			if( thisPtr->e1406 && 0 > thisPtr->numEventHandlers)
			{
				errStatus = viEnableEvent( vi,
				  VI_EVENT_SERVICE_REQ, VI_HNDLR, VI_NULL);
				if( errStatus)
				{
					age8481a_LOG_STATUS( vi, thisPtr, errStatus);
				}
			}	

			/* error - event handler already exists */
			sprintf(errMsg, 
			  age8481a_MSG_EVENT_HDLR_INSTALLED
			  " %ld.  "
			  age8481a_MSG_EVENT_HDLR_INST2, (long)happening);
			
			age8481a_LOG_STATUS( vi, thisPtr, VI_ERROR_PARAMETER2);			
		}

		/* store handler and user data */
		thisPtr->eventHandlerArray[hapIdx].eventHandler = eventHandler;
		thisPtr->eventHandlerArray[hapIdx].userData = userData;

		/* do we need to install the event handler? */
		if( 1 == thisPtr->numEventHandlers)
		{
			/* install the event handler */
			if (thisPtr->e1406)
			{
				errStatus = viInstallHandler(vi, 
				  VI_EVENT_SERVICE_REQ, age8481a_srqHdlr, VI_NULL);
				if( errStatus)
				{
               				age8481a_LOG_STATUS( vi, thisPtr, errStatus);
				}

				/* enable events */
				errStatus = viEnableEvent( vi,
				  VI_EVENT_SERVICE_REQ, VI_HNDLR, VI_NULL);
				if( errStatus)
				{
					age8481a_LOG_STATUS( vi, thisPtr, errStatus);
				}
			}
			else
			{
				instr_onsrq(vi,age8481a_rb_srqHdlr);
			}
		}
	} /* if - install event handler */
	else
	{
		/* see if event handler already exists */		
		if( NULL != thisPtr->eventHandlerArray[hapIdx].eventHandler )
		{
			/* okay - no event handler */
			thisPtr->numEventHandlers =
			  thisPtr->numEventHandlers - 1;
		}

		/* clear handler and user data */
		thisPtr->eventHandlerArray[hapIdx].eventHandler = NULL;
		thisPtr->eventHandlerArray[hapIdx].userData = NULL;

		/* do we need to uninstall the event handler? */
		if( 0 == thisPtr->numEventHandlers)
		{
			/* disable SRQ events */
			if (thisPtr->e1406)
			{
				errStatus = viDisableEvent( vi,
				  VI_EVENT_SERVICE_REQ ,VI_HNDLR);
				if( VI_SUCCESS > errStatus)
				{
					age8481a_LOG_STATUS( vi, thisPtr, errStatus);
				}

				/* flush any pending SRQ events */
				errStatus = viDiscardEvents( vi,
				  VI_EVENT_SERVICE_REQ ,VI_SUSPEND_HNDLR);
				if( VI_SUCCESS > errStatus)
				{
					age8481a_LOG_STATUS( vi, thisPtr, errStatus);
				}

				/* uninstall the event handler */
				errStatus = viUninstallHandler(vi, 
				  VI_EVENT_SERVICE_REQ, age8481a_srqHdlr, VI_NULL);
				if( VI_SUCCESS > errStatus &&
				    VI_ERROR_INV_HNDLR_REF != errStatus)
				{
					age8481a_LOG_STATUS( vi, thisPtr, errStatus);
				}
			}
			else
			{
				instr_onsrq(vi,0);
			}
		}
		/* remove all stale events */
		errStatus = age8481a_readAllEvents( vi);
		if( VI_SUCCESS > errStatus)
		{
			age8481a_LOG_STATUS( vi, thisPtr, errStatus);
		}

	} /* else - remove event handler */

	/* enable event bits to propagate through the IEEE 488.2 
	 * status system and eventually assert SRQ.
	 */
	propagate = happening;
	while( propagate > 0)
	{
		regNum = propagate / 100;
		bitNum = propagate % 100;

		/* get access index */
		if( VI_FALSE == age8481a_findAccessIdx( regNum * 100, &accessIdx))
		{
			age8481a_CDE_MESSAGE( "age8481a_findAccessIdx failed");
			age8481a_LOG_STATUS( vi, thisPtr, age8481a_INSTR_ERROR_UNEXPECTED);
		}

		/* query enable value from instrument */
		if (thisPtr->e1406)
		{
			thisPtr->blockSrqIO = VI_TRUE;

			errStatus = viPrintf( vi, "%s?\n",
				 age8481a_accessInfo[accessIdx].enableCmd);
			if( VI_SUCCESS > errStatus)
			{
				age8481a_LOG_STATUS( vi, thisPtr, errStatus);
			}

			/* read back the response */
			errStatus = viScanf( vi, "%ld%*t", &enableMask);
			if( VI_SUCCESS > errStatus)
			{
				age8481a_LOG_STATUS( vi, thisPtr, errStatus);
			}
		}
		else
		{
			ViChar cmd_str[100];
			ViChar resp_str[100];

			sprintf(cmd_str, "%s?\n", 
			        age8481a_accessInfo[accessIdx].enableCmd);

			cscpi_exe( vi, cmd_str, strlen(cmd_str),
				  resp_str, sizeof(resp_str) );
			/* get the response */
			enableMask = atol(resp_str);
		}

		/* enable/disable  the corresponding event bit */
		if( NULL != eventHandler)
		{
			/* enable event bit */
			enableMask = enableMask | (1 << (bitNum - 1));
		}	
		else
		{
			/* disable event bit */
			enableMask = enableMask & (~(1 << (bitNum - 1)));
		}

		/* write back the new enable mask */
		if (thisPtr->e1406)
		{
			errStatus = viPrintf( vi, "%s %hd\n",
			   age8481a_accessInfo[accessIdx].enableCmd,
			   enableMask);
			if( VI_SUCCESS > errStatus)
			{
				age8481a_LOG_STATUS( vi, thisPtr, errStatus);
			}
		}
		else
		{
			ViChar cmd_str[100];

			sprintf(cmd_str, "%s %hd\n", 
			        age8481a_accessInfo[accessIdx].enableCmd,
			        enableMask);
			cscpi_exe( vi, cmd_str, strlen(cmd_str), 0, 0);
		}

		if( NULL == eventHandler)
		{
			/* for disabling events, only disable the
			 * lowest level.
			 */
			propagate = 0;
		}
		else
		{
			propagate = propagate / 100;
		}
	} /* while - propagate */
	age8481a_LOG_STATUS( vi, thisPtr, VI_SUCCESS);
}	

/****************************************************************************
age8481a_statEvenHdlr_Q
*****************************************************************************
    Parameter Name                                       Type    Direction
   ------------------------------------------------------------------------
  | vi                                                ViSession   IN
  |   ---------------------------------------------------------------------
  |  | Instrument Handle returned from age8481a_init()
   ------------------------------------------------------------------------
  | happening                                         ViInt32 happeningIN
  |   ---------------------------------------------------------------------
  |  | Happenings refer to something that happens.  These can refer to
  |  | conditions or events.  Happenings are enumerated as ViInt32
  |  | numbers.
  |  |
   ------------------------------------------------------------------------
  | pEventHandler                     age8481a_InstrPEventHandler      OUT
  |   ---------------------------------------------------------------------
  |  | This is the definition of a age8481a_InstrPEventHandler:
  |  |
  |  | typedef void (_VI_PTR _VI_PTR age8481a_InstrPEventHandler)(
  |  | ViSession vi,
  |  | ViInt32 happening,
  |  | ViAddr userData
  |  | );
   ------------------------------------------------------------------------
  | pUserData                                         ViPAddr     OUT
  |   ---------------------------------------------------------------------
  |  | This is a pointer to the userData that was registered
  |  | with the handler.

*****************************************************************************/

ViStatus _VI_FUNC age8481a_statEvenHdlr_Q(INST vi,
										  ViInt32 happening,
										  age8481a_InstrPEventHandler pEventHandler,
										  ViPAddr pUserData)
{
	ViUInt16 intf;
	struct age8481a_globals *thisPtr;
	ViStatus errStatus;
	ViInt32 hapIdx;
	char errMsg[80];

	/* initialize output parameters */
	viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
	if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
	{
		errStatus = viGetAttribute(
				vi, VI_ATTR_USER_DATA, (ViPAddr) &thisPtr);
	}
	else
	{
		errStatus = instr_getdata( vi,  (ViPAddr) &thisPtr);
	}
	if( VI_SUCCESS > errStatus)
	{
		/* Errors: VI_ERROR_INV_SESSION */
		age8481a_LOG_STATUS( vi, NULL, errStatus);
	}
	age8481a_DEBUG_CHK_THIS( vi, thisPtr);
	age8481a_CDE_INIT( "age8481a_statEvenHdlr_Q");

	/* check validity of happening */
	if( age8481a_USER_ERROR_HANDLER == happening)
	{
		hapIdx = age8481a_USER_ERROR_HANDLER_IDX;
	}
	else if( VI_FALSE == age8481a_findHappeningIdx( happening, &hapIdx) )
	{
		sprintf(errMsg,"%hd " age8481a_MSG_INVALID_HAPPENING, happening);
		age8481a_CDE_MESSAGE( errMsg);
		age8481a_LOG_STATUS( vi, thisPtr, VI_ERROR_PARAMETER2);
	}

	*((void **)pEventHandler) = (void *)thisPtr->eventHandlerArray[hapIdx].eventHandler;
	*pUserData = thisPtr->eventHandlerArray[hapIdx].userData;

	age8481a_LOG_STATUS( vi, thisPtr, VI_SUCCESS);
}	

/****************************************************************************
age8481a_statEvenHdlrDelAll
*****************************************************************************
    Parameter Name                                       Type    Direction
   ------------------------------------------------------------------------
  | vi                                                ViSession   IN
  |   ---------------------------------------------------------------------
  |  | Instrument Handle returned from age8481a_init()

*****************************************************************************/

ViStatus _VI_FUNC age8481a_statEvenHdlrDelAll(INST vi)
{
	ViUInt16 intf;
	struct age8481a_globals *thisPtr;
	ViStatus errStatus;

	/* initialize output parameters */

	viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
	if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
	{
		errStatus = viGetAttribute(
				vi, VI_ATTR_USER_DATA, (ViPAddr) &thisPtr);
	}
	else
	{
		errStatus = instr_getdata( vi,  (ViPAddr) &thisPtr);
	}
	if( VI_SUCCESS > errStatus)
	{
		/* Errors: VI_ERROR_INV_SESSION */
		age8481a_LOG_STATUS( vi, NULL, errStatus);
	}
	age8481a_DEBUG_CHK_THIS( vi, thisPtr);
	age8481a_CDE_INIT( "age8481a_statEvenHdlrDelAll");

	/* disable SRQ events */
	if (thisPtr->e1406)
	{
		errStatus = viDisableEvent( vi,VI_EVENT_SERVICE_REQ ,VI_HNDLR);
		if( VI_SUCCESS > errStatus)
		{
			age8481a_LOG_STATUS( vi, thisPtr, errStatus);
		}

		/* flush any pending SRQ events */
		errStatus = viDiscardEvents( vi,VI_EVENT_SERVICE_REQ ,VI_SUSPEND_HNDLR);
		if( VI_SUCCESS > errStatus)
		{
			age8481a_LOG_STATUS( vi, thisPtr, errStatus);
		}

		/* uninstall the event handler */
		errStatus = viUninstallHandler(vi, 
		  VI_EVENT_SERVICE_REQ, age8481a_srqHdlr, VI_NULL);
		if( VI_SUCCESS > errStatus &&
		    VI_ERROR_INV_HNDLR_REF != errStatus)
		{
			age8481a_LOG_STATUS( vi, thisPtr, errStatus);
		}
	}
	else
	{
		instr_onsrq(vi,0);
	}
	age8481a_LOG_STATUS( vi, thisPtr, VI_SUCCESS);
}	

/****************************************************************************
age8481a_statEvenClr
*****************************************************************************
    Parameter Name                                       Type    Direction
   ------------------------------------------------------------------------
  | vi                                                ViSession   IN
  |   ---------------------------------------------------------------------
  |  | Instrument Handle returned from age8481a_init()

*****************************************************************************/

ViStatus _VI_FUNC age8481a_statEvenClr(INST vi)
{
	ViUInt16 intf;
	struct age8481a_globals *thisPtr;
	ViStatus errStatus;
	ViInt32 idx;

	viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
	if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
	{
		errStatus = viGetAttribute(
			vi, VI_ATTR_USER_DATA, (ViPAddr) &thisPtr);
	}
	else
	{
		errStatus = instr_getdata( vi,  (ViPAddr) &thisPtr);
	}
	if( VI_SUCCESS > errStatus)
	{
		/* Errors: VI_ERROR_INV_SESSION */
		age8481a_LOG_STATUS( vi, NULL, errStatus);
	}
	age8481a_DEBUG_CHK_THIS( vi, thisPtr);
	age8481a_CDE_INIT( "age8481a_statEvenClr");

	/* clear instrument events */
	if (thisPtr->e1406)
	{
		errStatus = viPrintf(vi, "*CLS\n");
		if( VI_SUCCESS > errStatus)
		{
			age8481a_LOG_STATUS( vi, thisPtr, errStatus);
		}
	}
	else
	{
		{{ 
//#line 2953 "age8481a.cs"
{extern sw_cls();instr_send(vi,sw_cls,(void*)0);}}}
	}

	/* clear driver copy of instrument events */
	for(idx=0; idx<age8481a_MAX_STAT_REG; idx++)
	{
		thisPtr->driverEventArray[idx] = 0;
	}
	age8481a_LOG_STATUS( vi, thisPtr, VI_SUCCESS);
}	

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC age8481a_abor
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  The age8481a_abor function stops a scan in progress when
 *            trigger source is age8481a_TRIG_SOUR_BUS or
 *           age8481a_TRIG_SOUR_HOLD.
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "age8481a_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
ViStatus _VI_FUNC age8481a_abor(INST vi)
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct age8481a_globals *thisPtr;

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViPAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViPAddr) &thisPtr);
    }
    if (VI_SUCCESS > errStatus)
	{
		age8481a_LOG_STATUS( vi, 0, errStatus );
	}

    age8481a_DEBUG_CHK_THIS( vi, thisPtr );
    age8481a_CDE_INIT( "age8481a_abor" );

    if (thisPtr->e1406)
    {
        errStatus = viPrintf(vi,"ABOR\n");
        if (VI_SUCCESS > errStatus)
        {
            age8481a_LOG_STATUS( vi, thisPtr, errStatus );
        }
    }
    else
    {
        {{ 
//#line 3015 "age8481a.cs"
{extern sw_abort();instr_send(vi,sw_abort,(void*)0);}}}
    }
    age8481a_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC age8481a_armCoun
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  age8481a_armCoun  allows
 *            scanning cycles to occur a multiple of times (1
 *            to 32767) with one age8481a_initImm function and when
 *           age8481a_initCont is set to 0 (off).
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViInt16 armCoun
 * IN        
 *            The number of arm counts.
 * 
 *      MAX = age8481a_ARM_COUN_MAX   32767
 *      MIN = age8481a_ARM_COUN_MIN   1
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "age8481a_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
ViStatus _VI_FUNC age8481a_armCoun(INST vi,
								   ViInt16 armCoun)
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct age8481a_globals *thisPtr;

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViPAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViPAddr) &thisPtr);
    }
    if (VI_SUCCESS > errStatus){ age8481a_LOG_STATUS( vi, 0, errStatus ); }

    age8481a_DEBUG_CHK_THIS( vi, thisPtr );
    age8481a_CDE_INIT( "age8481a_armCoun" );

    /* Perform Error Checking on Each Parameter */
    age8481a_CHK_INT_RANGE(armCoun, age8481a_ARM_COUN_MIN,
						   age8481a_ARM_COUN_MAX, VI_ERROR_PARAMETER2);

    if (thisPtr->e1406)
    {
        errStatus = viPrintf(vi,"ARM:COUN %d\n",armCoun);
        if (VI_SUCCESS > errStatus)
        {
            age8481a_LOG_STATUS( vi, thisPtr, errStatus );
        }
    }
    else
    {
        {{ struct {short p1_type; char p1_type_pad[6]; double p1[1];} in_;
//#line 3081 "age8481a.cs"
in_.p1_type= 0;((HPSL_INT16*)in_.p1)->num=(armCoun);
//#line 3081 "age8481a.cs"
((HPSL_INT16*)in_.p1)->suffix=0;
//#line 3081 "age8481a.cs"
{extern sw_trigcoun();instr_send(vi,sw_trigcoun,&in_);}}}
    }
    age8481a_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC age8481a_armCoun_Q
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  age8481a_armCoun_Q returns current number of scanning
 *            cycles set by age8481a_armCoun.
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViPInt16 armCoun
 * OUT       
 *            Returns current number of arm counts.
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "age8481a_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
ViStatus _VI_FUNC age8481a_armCoun_Q(INST vi,
									 ViPInt16 armCoun)
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct age8481a_globals *thisPtr;

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViPAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViPAddr) &thisPtr);
    }
    if (VI_SUCCESS > errStatus){ age8481a_LOG_STATUS( vi, 0, errStatus ); }

    age8481a_DEBUG_CHK_THIS( vi, thisPtr );
    age8481a_CDE_INIT( "age8481a_armCoun_Q" );

    if (thisPtr->e1406)
    {
        thisPtr->blockSrqIO = VI_TRUE;
        errStatus = viPrintf(vi,"ARM:COUN?\n");
        if (VI_SUCCESS > errStatus)
        {
            age8481a_LOG_STATUS( vi, thisPtr, errStatus );
        }
        errStatus = viScanf(vi,"%hd%*t",armCoun);
        if (VI_SUCCESS > errStatus)
        {
            age8481a_LOG_STATUS( vi, thisPtr, errStatus );
        }
    }
    else
    {
        {{ struct {short p1_type; char p1_type_pad[6]; double p1[1];} in_;struct {double p1[1];} out_;
//#line 3144 "age8481a.cs"
in_.p1_type= -1;
//#line 3144 "age8481a.cs"
{extern sw_trigcoun_q();if (!instr_query(vi,sw_trigcoun_q,&in_,&out_)){
//#line 3144 "age8481a.cs"
*armCoun=(*(HPSL_INT16*)out_.p1).num;}}}}
    }
    age8481a_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}


/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC age8481a_closRowCol4x32
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  age8481a_closRowCol4x32 closes the matrix channel on row number
 *           (0-3) and column number (0-31) on the E1466 card specified.
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViInt16 Card_Number
 * IN        
 *            Numeric value of the card in a switchbox.  In a single-card
 *           switchbox, the card number is 1.
 * 
 *      MAX = age8481a_CARD_MAX   99
 *      MIN = age8481a_CARD_MIN   1
 * 
 * PARAM 3 : ViInt16 Row
 * IN        
 *            The row number of the matrix switch to be closed (0-3).
 * 
 *      MAX = age8481a_ROW_MAX   3
 *      MIN = age8481a_ROW_MIN   0
 * 
 * PARAM 4 : ViInt16 Column
 * IN        
 *            The column number of the matrix switch to be closed (0-31).
 * 
 *      MAX = age8481a_COL_MAX   31
 *      MIN = age8481a_COL_MIN   0
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "age8481a_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
ViStatus _VI_FUNC age8481a_closRowCol4x32(INST vi,
										  ViInt16 Card_Number,
										  ViInt16 Row,
										  ViInt16 Column)
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct age8481a_globals *thisPtr;
	ViUInt32 chan_num;

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViPAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViPAddr) &thisPtr);
    }
    if (VI_SUCCESS > errStatus)
	{
		age8481a_LOG_STATUS( vi, 0, errStatus );
	}

    age8481a_DEBUG_CHK_THIS( vi, thisPtr );
    age8481a_CDE_INIT( "age8481a_closRowCol4x32" );

    /* Perform Error Checking on Each Parameter */
    age8481a_CHK_INT_RANGE(Card_Number, age8481a_CARD_MIN,
						   age8481a_CARD_MAX, VI_ERROR_PARAMETER2);
    age8481a_CHK_INT_RANGE(Row, age8481a_ROW_MIN,
						   age8481a_ROW_MAX, VI_ERROR_PARAMETER3);
    age8481a_CHK_INT_RANGE(Column, age8481a_COL_MIN,
						   age8481a_COL_MAX, VI_ERROR_PARAMETER4);

    chan_num = (Card_Number * 10000) + (Row * 100) + Column;
    if (thisPtr->e1406)
    {
        errStatus = viPrintf(vi,"CLOS (@%ld)\n",chan_num);
        if (errStatus < VI_SUCCESS)
        {
            age8481a_LOG_STATUS( vi, thisPtr, errStatus );
        }
    }
    else
    {
    	long old_error;
    
    	old_error = instr_error_head(vi);
    	{{ struct {short p1_type; char p1_type_pad[6]; double p1[1];} in_;
//#line 3238 "age8481a.cs"
HPSL_CHANNEL_LIST bl_1[1];
//#line 3238 "age8481a.cs"
in_.p1_type= 5;
//#line 3238 "age8481a.cs"
bl_1[0].number=chan_num;*(HPSL_CHANNEL_PTR*)in_.p1=bl_1;bl_1[0].type= 1;bl_1[0].next= 0;
//#line 3238 "age8481a.cs"
{extern sw_clos();instr_send(vi,sw_clos,&in_);}}}
    	if (old_error != instr_error_head(vi))
    	{ /* must have been bad card number*/
    		age8481a_LOG_STATUS( vi, thisPtr, VI_ERROR_PARAMETER2);
    	}
    }
    age8481a_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC age8481a_initCont
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  age8481a_initCont enables or
 *            disables continuous scanning cycles for the switchbox.
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViBoolean initCont
 * IN        
 *           0 = continuous scanning disabled
 *           1 = continuous scanning enabled
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "age8481a_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
ViStatus _VI_FUNC age8481a_initCont(INST vi,
									ViBoolean initCont)
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct age8481a_globals *thisPtr;

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViPAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViPAddr) &thisPtr);
    }
    if (VI_SUCCESS > errStatus)
	{
		age8481a_LOG_STATUS( vi, 0, errStatus );
	}

    age8481a_DEBUG_CHK_THIS( vi, thisPtr );
    age8481a_CDE_INIT( "age8481a_initCont" );

    /* Perform Error Checking on Each Parameter */
    age8481a_CHK_BOOLEAN(initCont,VI_ERROR_PARAMETER2);

    if (thisPtr->e1406)
    {
        errStatus = viPrintf(vi,"INIT:CONT %u\n",initCont);
        if (VI_SUCCESS > errStatus)
        {
            age8481a_LOG_STATUS( vi, thisPtr, errStatus );
        }
    }
    else
    {
        {{ struct {short p1_type; char p1_type_pad[6]; double p1[1];} in_;
//#line 3306 "age8481a.cs"
in_.p1_type= 0;*(HPSL_BOOLEAN*)in_.p1= ((initCont)!=0);
//#line 3306 "age8481a.cs"
{extern sw_initcont();instr_send(vi,sw_initcont,&in_);}}}
    }
    age8481a_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC age8481a_initCont_Q
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  age8481a_initCont_Q queries the scanning state.
 *            With continuous scanning enabled,
 *            the function returns 1.  With continuous scanning disabled,
 *            the function returns 0.
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViPBoolean initCont
 * OUT       
 *           Returns 0 when continuous scanning is disabled.
 *           Returns 1 when continuous scanning is enabled.
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "age8481a_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
ViStatus _VI_FUNC age8481a_initCont_Q(INST vi,
									  ViPBoolean initCont)
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct age8481a_globals *thisPtr;

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViPAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViPAddr) &thisPtr);
    }
    if (VI_SUCCESS > errStatus)
	{
		age8481a_LOG_STATUS( vi, 0, errStatus );
	}

    age8481a_DEBUG_CHK_THIS( vi, thisPtr );
    age8481a_CDE_INIT( "age8481a_initCont_Q" );

    if (thisPtr->e1406)
    {
        thisPtr->blockSrqIO = VI_TRUE;
        errStatus = viPrintf(vi,"INIT:CONT?\n");
        if (VI_SUCCESS > errStatus)
        {
            age8481a_LOG_STATUS( vi, thisPtr, errStatus );
        }
        errStatus = viScanf(vi,"%hd%*t",initCont);
        if (VI_SUCCESS > errStatus)
        {
            age8481a_LOG_STATUS( vi, thisPtr, errStatus );
        }
    }
    else
    {
        {{ struct {double p1[1];} out_;
//#line 3375 "age8481a.cs"
{extern sw_initcont_q();if (!instr_query(vi,sw_initcont_q,(void*)0,&out_)){
//#line 3375 "age8481a.cs"
*initCont=*(HPSL_BOOLEAN*)out_.p1;}}}}
    }
    age8481a_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC age8481a_initImm
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  age8481a_initImm  starts the scanning cycle
 *            and closes the first channel in the channel list.  Successive
 *            triggers from the source specified by the age8481a_trigSour
 *            function advances the scan through the channel list.
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "age8481a_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
ViStatus _VI_FUNC age8481a_initImm(INST vi)
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct age8481a_globals *thisPtr;

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViPAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViPAddr) &thisPtr);
    }
    if (VI_SUCCESS > errStatus)
	{
		age8481a_LOG_STATUS( vi, 0, errStatus );
	}

    age8481a_DEBUG_CHK_THIS( vi, thisPtr );
    age8481a_CDE_INIT( "age8481a_initImm" );

    if (thisPtr->e1406)
    {
        errStatus = viPrintf(vi,"INIT:IMM\n");
        if (VI_SUCCESS > errStatus)
        {
            age8481a_LOG_STATUS( vi, thisPtr, errStatus );
        }
    }
    else
    {
        {{ 
//#line 3432 "age8481a.cs"
{extern sw_init();instr_send(vi,sw_init,(void*)0);}}}
    }
    age8481a_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC age8481a_outpEcltStat_M
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  age8481a_outpEcltStat_M Selects and enables which ECL Trigger
 *            bus line (0 or 1) will output a trigger when a channel is
 *           closed during a scan.  This is also used to disable a selected
 *           ECL Trigger bus line.  "Line" specifies the ECL Trigger
 *            bus line (0 or 1) and "mode" enables
 *            (1) or disables (0) the specified ECLTrg bus line.
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViInt16 ecltNum
 * IN        
 *            Numeric suffix for header ECLT.
 * 
 *      MAX = age8481a_ECLTNUM_MAX   1
 *      MIN = age8481a_ECLTNUM_MIN   0
 * 
 * PARAM 3 : ViBoolean outpEcltStat
 * IN        
 *            Enables or disables the ECL trigger bus line.
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "age8481a_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
ViStatus _VI_FUNC age8481a_outpEcltStat_M(INST vi,
										  ViInt16 ecltNum,
										  ViBoolean outpEcltStat)
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct age8481a_globals *thisPtr;

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViPAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViPAddr) &thisPtr);
    }
    if (VI_SUCCESS > errStatus)
	{
		age8481a_LOG_STATUS( vi, 0, errStatus );
	}

    age8481a_DEBUG_CHK_THIS( vi, thisPtr );
    age8481a_CDE_INIT( "age8481a_outpEcltStat_M" );

    /* Perform Error Checking on Each Parameter */
    age8481a_CHK_INT_RANGE(ecltNum, age8481a_ECLTNUM_MIN,
						   age8481a_ECLTNUM_MAX, VI_ERROR_PARAMETER2);
    age8481a_CHK_BOOLEAN(outpEcltStat,VI_ERROR_PARAMETER3);

    if (thisPtr->e1406)
    {
        errStatus = viPrintf(vi,"OUTP:ECLT%d:STAT %u\n",ecltNum,outpEcltStat);
        if (VI_SUCCESS > errStatus)
        {
            age8481a_LOG_STATUS( vi, thisPtr, errStatus );
        }
    }
    else
    {
        {{ struct {short sub1;char sub_pad[6];short p1_type; char p1_type_pad[6]; double p1[1];} in_;
//#line 3509 "age8481a.cs"
in_.sub1= (ecltNum) - -8;
//#line 3509 "age8481a.cs"
in_.p1_type= 0;*(HPSL_BOOLEAN*)in_.p1= ((outpEcltStat)!=0);
//#line 3509 "age8481a.cs"
{extern sw_trigttl();instr_send(vi,sw_trigttl,&in_);}}}
    }
    age8481a_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC age8481a_outpEcltStat_M_Q
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  age8481a_outpEcltStat_M_Q  Queries the present state of the
 *           specified ECL Trigger bus line.  The function
 *            returns "1" if the specified bus line is enabled or "0" if the
 *           specified bus line is disabled.
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViInt16 ecltNum
 * IN        
 *            Numeric suffix for header ECLT.
 * 
 *      MAX = age8481a_ECLTNUM_MAX   1
 *      MIN = age8481a_ECLTNUM_MIN   0
 * 
 * PARAM 3 : ViPBoolean outpEcltStat
 * OUT       
 *            Returns the state of the selected ECL trigger bus line.
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "age8481a_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
ViStatus _VI_FUNC age8481a_outpEcltStat_M_Q(INST vi,
											ViInt16 ecltNum,
											ViPBoolean outpEcltStat)
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct age8481a_globals *thisPtr;

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViPAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViPAddr) &thisPtr);
    }
    if (VI_SUCCESS > errStatus)
	{
		age8481a_LOG_STATUS( vi, 0, errStatus );
	}

    age8481a_DEBUG_CHK_THIS( vi, thisPtr );
    age8481a_CDE_INIT( "age8481a_outpEcltStat_M_Q" );

    /* Perform Error Checking on Each Parameter */
    age8481a_CHK_INT_RANGE(ecltNum, age8481a_ECLTNUM_MIN,
						   age8481a_ECLTNUM_MAX, VI_ERROR_PARAMETER2);

    if (thisPtr->e1406)
    {
        thisPtr->blockSrqIO = VI_TRUE;
        errStatus = viPrintf(vi,"OUTP:ECLT%d:STAT?\n",ecltNum);
        if (VI_SUCCESS > errStatus)
        {
            age8481a_LOG_STATUS( vi, thisPtr, errStatus );
        }
        errStatus = viScanf(vi,"%hd%*t",outpEcltStat);
        if (VI_SUCCESS > errStatus)
        {
            age8481a_LOG_STATUS( vi, thisPtr, errStatus );
        }
    }
    else
    {
        {{ struct {short sub1;char sub_pad[6];} in_;struct {double p1[1];} out_;
//#line 3589 "age8481a.cs"
in_.sub1= (ecltNum) - -8;
//#line 3589 "age8481a.cs"
{extern sw_trigttl_q();if (!instr_query(vi,sw_trigttl_q,&in_,&out_)){
//#line 3589 "age8481a.cs"
*outpEcltStat=*(HPSL_BOOLEAN*)out_.p1;}}}}
    }
    age8481a_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC age8481a_outpStat
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  age8481a_outpStat enables/disables the "Trig Out" port to be
 *           pulsed when a channel is closed during a scan.
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViBoolean outpStat
 * IN        
 *            Enables or disables the Trig Out port.
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "age8481a_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
ViStatus _VI_FUNC age8481a_outpStat(INST vi,
									ViBoolean outpStat)
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct age8481a_globals *thisPtr;

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViPAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViPAddr) &thisPtr);
    }
    if (VI_SUCCESS > errStatus)
	{
		age8481a_LOG_STATUS( vi, 0, errStatus );
	}

    age8481a_DEBUG_CHK_THIS( vi, thisPtr );
    age8481a_CDE_INIT( "age8481a_outpStat" );

    /* Perform Error Checking on Each Parameter */
    age8481a_CHK_BOOLEAN(outpStat,VI_ERROR_PARAMETER2);

    if (thisPtr->e1406)
    {
        errStatus = viPrintf(vi,"OUTP %u\n",outpStat);
        if (VI_SUCCESS > errStatus)
        {
            age8481a_LOG_STATUS( vi, thisPtr, errStatus );
        }
    }
    else
    {
        {{ struct {short p1_type; char p1_type_pad[6]; double p1[1];} in_;
//#line 3652 "age8481a.cs"
in_.p1_type= 0;*(HPSL_BOOLEAN*)in_.p1= ((outpStat)!=0);
//#line 3652 "age8481a.cs"
{extern sw_trigout();instr_send(vi,sw_trigout,&in_);}}}
    }
    age8481a_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC age8481a_outpStat_Q
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  age8481a_outpStat_Q  Queries the present state of the Trig Out
 *           port. The function returns "1" if the port is enabled or "0" if
 *           the port is disabled.
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViPBoolean outpStat
 * OUT       
 *            Returns the enabling state of the Trig Out port.
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "age8481a_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
ViStatus _VI_FUNC age8481a_outpStat_Q(INST vi,
									  ViPBoolean outpStat)
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct age8481a_globals *thisPtr;

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViPAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViPAddr) &thisPtr);
    }
    if (VI_SUCCESS > errStatus)
	{
		age8481a_LOG_STATUS( vi, 0, errStatus );
	}

    age8481a_DEBUG_CHK_THIS( vi, thisPtr );
    age8481a_CDE_INIT( "age8481a_outpStat_Q" );

    /* Perform Error Checking on Each Parameter */
    if (thisPtr->e1406)
    {
        thisPtr->blockSrqIO = VI_TRUE;
        errStatus = viPrintf(vi,"OUTP:STAT?\n");
        if (VI_SUCCESS > errStatus)
        {
            age8481a_LOG_STATUS( vi, thisPtr, errStatus );
        }
        errStatus = viScanf(vi,"%hd%*t",outpStat);
        if (VI_SUCCESS > errStatus)
        {
            age8481a_LOG_STATUS( vi, thisPtr, errStatus );
        }
    }
    else
    {
		{{ struct {double p1[1];} out_;
//#line 3720 "age8481a.cs"
{extern sw_trigout_q();if (!instr_query(vi,sw_trigout_q,(void*)0,&out_)){
//#line 3720 "age8481a.cs"
*outpStat=*(HPSL_BOOLEAN*)out_.p1;}}}}
    }
    age8481a_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC age8481a_outpTtltStat_M
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  age8481a_outpTtltStat_M Selects
 *            and enables which TTL Trigger
 *            bus line (0 to 7) will output a trigger
 *            when a channel is closed during a scan.  This is also used to
 *           disable a selected TTL Trigger bus line.  "Line" specifies the
 *           TTL Trigger bus line (0 to 7) and "mode" enables
 *            (1) or disables (0) the specified TTL Trigger bus line.
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViInt16 ttltNum
 * IN        
 *            Numeric suffix for header TTLT.
 * 
 *      MAX = age8481a_TTLTNUM_MAX   7
 *      MIN = age8481a_TTLTNUM_MIN   0
 * 
 * PARAM 3 : ViBoolean outpTtltStat
 * IN        
 *            Enables or disables the TTLT trigger bus line.
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "age8481a_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
ViStatus _VI_FUNC age8481a_outpTtltStat_M(INST vi,
										  ViInt16 ttltNum,
										  ViBoolean outpTtltStat)
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct age8481a_globals *thisPtr;

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViPAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViPAddr) &thisPtr);
    }
    if (VI_SUCCESS > errStatus)
	{
		age8481a_LOG_STATUS( vi, 0, errStatus );
	}

    age8481a_DEBUG_CHK_THIS( vi, thisPtr );
    age8481a_CDE_INIT( "age8481a_outpTtltStat_M" );

    /* Perform Error Checking on Each Parameter */
    age8481a_CHK_INT_RANGE(ttltNum, age8481a_TTLTNUM_MIN,
						   age8481a_TTLTNUM_MAX, VI_ERROR_PARAMETER2);
    age8481a_CHK_BOOLEAN(outpTtltStat,VI_ERROR_PARAMETER3);

    if (thisPtr->e1406)
    {
        errStatus = viPrintf(vi,"OUTP:TTLT%d:STAT %u\n",ttltNum,outpTtltStat);
        if (VI_SUCCESS > errStatus)
        {
            age8481a_LOG_STATUS( vi, thisPtr, errStatus );
        }
    }
    else
    {
        {{ struct {short sub1;char sub_pad[6];short p1_type; char p1_type_pad[6]; double p1[1];} in_;
//#line 3798 "age8481a.cs"
in_.sub1= ttltNum;
//#line 3798 "age8481a.cs"
in_.p1_type= 0;*(HPSL_BOOLEAN*)in_.p1= ((outpTtltStat)!=0);
//#line 3798 "age8481a.cs"
{extern sw_trigttl();instr_send(vi,sw_trigttl,&in_);}}}
    }
    age8481a_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC age8481a_outpTtltStat_M_Q
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  age8481a_outpTtltStat_M_Q  Queries the present state of the
 *           specified TTL Trigger bus line.  The function returns "1" if the
 *           specified TTLTrg bus line is enabled or "0" if disabled.
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViInt16 ttltNum
 * IN        
 *            Numeric suffix for header TTLT.
 * 
 *      MAX = age8481a_TTLTNUM_MAX   7
 *      MIN = age8481a_TTLTNUM_MIN   0
 * 
 * PARAM 3 : ViPBoolean outpTtltStat
 * OUT       
 *            Returns the state of the selected TTLT trigger bus line.
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "age8481a_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
ViStatus _VI_FUNC age8481a_outpTtltStat_M_Q(INST vi,
											ViInt16 ttltNum,
											ViPBoolean outpTtltStat)
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct age8481a_globals *thisPtr;

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViPAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViPAddr) &thisPtr);
    }
    if (VI_SUCCESS > errStatus)
	{
		age8481a_LOG_STATUS( vi, 0, errStatus );
	}

    age8481a_DEBUG_CHK_THIS( vi, thisPtr );
    age8481a_CDE_INIT( "age8481a_outpTtltStat_M_Q" );

    /* Perform Error Checking on Each Parameter */
    age8481a_CHK_INT_RANGE(ttltNum, age8481a_TTLTNUM_MIN,
						   age8481a_TTLTNUM_MAX, VI_ERROR_PARAMETER2);

    if (thisPtr->e1406)
    {
        thisPtr->blockSrqIO = VI_TRUE;
        errStatus = viPrintf(vi,"OUTP:TTLT%d:STAT?\n",ttltNum);
        if (VI_SUCCESS > errStatus)
        {
            age8481a_LOG_STATUS( vi, thisPtr, errStatus );
        }
        errStatus = viScanf(vi,"%hd%*t",outpTtltStat);
        if (VI_SUCCESS > errStatus)
        {
            age8481a_LOG_STATUS( vi, thisPtr, errStatus );
        }
    }
    else
    {
        {{ struct {short sub1;char sub_pad[6];} in_;struct {double p1[1];} out_;
//#line 3877 "age8481a.cs"
in_.sub1= ttltNum;
//#line 3877 "age8481a.cs"
{extern sw_trigttl_q();if (!instr_query(vi,sw_trigttl_q,&in_,&out_)){
//#line 3877 "age8481a.cs"
*outpTtltStat=*(HPSL_BOOLEAN*)out_.p1;}}}}
    }
    age8481a_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC age8481a_routClos
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  age8481a_routClos closes a matrix channel specified.
 *            The channel is in the form ssrrcc where ss = card number
 *           (01-99), rr = matrix row number (0-3), and cc = matrix column
 *           number (00-31).
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViInt32 channel
 * IN        
 *            Numeric value of the channel to be closed in the form ssrrcc
 *           where ss = card number (01-99),
 *            rr = matrix row number (0-3), and cc = matrix column number
 *           (00-31).
 * 
 *      MAX = age8481a_CHANNEL_MAX   999999
 *      MIN = age8481a_CHANNEL_MIN   100
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "age8481a_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
ViStatus _VI_FUNC age8481a_routClos(INST vi,
									ViInt32 channel)
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct age8481a_globals *thisPtr;

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViPAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViPAddr) &thisPtr);
    }
    if (VI_SUCCESS > errStatus)
	{
		age8481a_LOG_STATUS( vi, 0, errStatus );
	}

    age8481a_DEBUG_CHK_THIS( vi, thisPtr );
    age8481a_CDE_INIT( "age8481a_routClos" );

    /* Perform Error Checking on Each Parameter */
    age8481a_CHK_LONG_RANGE(channel, age8481a_CHANNEL_MIN,
						    age8481a_CHANNEL_MAX, VI_ERROR_PARAMETER2);

    if (thisPtr->e1406)
    {
        errStatus = viPrintf(vi,"CLOS (@%ld)\n",channel);
        if (errStatus < VI_SUCCESS)
        {
            age8481a_LOG_STATUS( vi, thisPtr, errStatus );
        }
    }
    else
    {
    	long old_error;
    
    	old_error = instr_error_head(vi);
    	{{ struct {short p1_type; char p1_type_pad[6]; double p1[1];} in_;
//#line 3952 "age8481a.cs"
HPSL_CHANNEL_LIST bl_1[1];
//#line 3952 "age8481a.cs"
in_.p1_type= 5;
//#line 3952 "age8481a.cs"
bl_1[0].number=channel;*(HPSL_CHANNEL_PTR*)in_.p1=bl_1;bl_1[0].type= 1;bl_1[0].next= 0;
//#line 3952 "age8481a.cs"
{extern sw_clos();instr_send(vi,sw_clos,&in_);}}}
    	if (old_error != instr_error_head(vi))
    	{ /* must have been bad channel list*/
    		age8481a_LOG_STATUS( vi, thisPtr, VI_ERROR_PARAMETER2);
    	}
    }
    age8481a_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC age8481a_routClosList
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  age8481a_routClosList closes matrix
 *            channels specified in the channelList.
 *            The channelList is in the form "ssrrcc", "ssrrcc,ssrrcc",
 *            or "ssrrcc:ccrc" where ss = card number (01-99),
 *            rr = matrix row number (0-3), and cc = matrix column number
 *            (00-31).
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViString channelList
 * IN        
 *            Channel list of the channels to be closed. The channelList is
 *           in the form "ssrrcc", "ssrrcc,ssrrcc", or "ssrrcc:ssrrcc"  where
 *           ss = card number (01-99), rr = matrix row number (0-3), and cc =
 *           matrix column number (00-31).
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "age8481a_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
ViStatus _VI_FUNC age8481a_routClosList(INST vi,
										ViString channelList)
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct age8481a_globals *thisPtr;

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViPAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViPAddr) &thisPtr);
    }
    if (VI_SUCCESS > errStatus)
	{
		age8481a_LOG_STATUS( vi, 0, errStatus );
	}

    age8481a_DEBUG_CHK_THIS( vi, thisPtr );
    age8481a_CDE_INIT( "age8481a_routClosList" );

    if (thisPtr->e1406)
    {
        errStatus = viPrintf(vi,"CLOS (@%s)\n",channelList);
        if (errStatus < VI_SUCCESS)
        {
            age8481a_LOG_STATUS( vi, thisPtr, errStatus );
        }
    }
    else
    {
    	char *cmd = malloc(strlen(channelList)+20);
    	long old_error;
    
    	if (!cmd)
    	{
    		age8481a_CDE_ERROR( VI_ERROR_ALLOC );
    		age8481a_LOG_STATUS( vi, thisPtr, VI_ERROR_ALLOC );
    	}
    	strcpy(cmd, "CLOS (@");
    	strcat(cmd, channelList);
    	strcat(cmd, ")");
    	old_error = instr_error_head(vi);
    	cscpi_exe(vi, cmd, strlen(cmd), 0, 0);
    	free(cmd);
    	if (old_error != instr_error_head(vi))
    	{ /* must have been bad channel list*/
    		age8481a_LOG_STATUS( vi, thisPtr, VI_ERROR_PARAMETER2);
    	}
    }
    age8481a_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC age8481a_routClosList_Q
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  age8481a_routClosList_Q returns
 *            the current state of the channels queried.
 *            The channelList is in the form "ssrrcc", "ssrrcc,ssrrcc",
 *            or "ssrrcc:ccrc" where ss = card number (01-99),
 *            rr = matrix row number (0-3), and cc = matrix column number
 *            (00-31). The function returns a comma separated list of 1's
 *            and 0's, 1 for each closed channel and 0 for each open channel.
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViString channelList
 * IN        
 *            Channel list of the channels to be queried. The channelList is
 *           in the form "ssrrcc", "ssrrcc,ssrrcc", or "ssrrcc:ssrrcc"  where
 *           ss = card number (01-99), rr = matrix row number (0-3) and cc = 
 *           matrix column number (00-31).
 * 
 * PARAM 3 : ViChar _VI_FAR routClosList[]
 * OUT       
 *           A comma separated list of 1's and 0's,
 *           1 for each closed channel and 0 for open channel.
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "age8481a_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
ViStatus _VI_FUNC age8481a_routClosList_Q(INST vi,
										  ViString channelList,
										  ViChar _VI_FAR routClosList[])
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct age8481a_globals *thisPtr;

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViPAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViPAddr) &thisPtr);
    }
    if (VI_SUCCESS > errStatus)
	{
		age8481a_LOG_STATUS( vi, 0, errStatus );
	}

    age8481a_DEBUG_CHK_THIS( vi, thisPtr );
    age8481a_CDE_INIT( "age8481a_routClosList_Q" );

    if (thisPtr->e1406)
    {
        thisPtr->blockSrqIO = VI_TRUE;
        errStatus = viPrintf(vi,"CLOS? (@%s)\n",channelList);
        if (errStatus < VI_SUCCESS)
        {
            age8481a_LOG_STATUS( vi, thisPtr, errStatus );
        }
        errStatus = viScanf(vi,"%t",routClosList);
        if (errStatus < VI_SUCCESS)
        {
            age8481a_LOG_STATUS( vi, thisPtr, errStatus );
        }
        /* remove trailing newline */
        if (routClosList[0])
    	routClosList[strlen(routClosList)-1] = 0;	
        else
        {
    	age8481a_LOG_STATUS( vi, thisPtr, VI_ERROR_PARAMETER2);
        }
    }
    else
    {
    	char *cmd = malloc(strlen(channelList)+20);
    	long old_error;
    
    	if (!cmd)
    	{
    		age8481a_CDE_ERROR( VI_ERROR_ALLOC );
    		age8481a_LOG_STATUS( vi, thisPtr, VI_ERROR_ALLOC );
    	}
    	strcpy(cmd, "CLOS? (@");
    	strcat(cmd, channelList);
    	strcat(cmd, ")");
    	old_error = instr_error_head(vi);
    	cscpi_exe(vi, cmd, strlen(cmd), routClosList, 32700);
    	/* remove trailing newline */
    	if (routClosList[0])
    		routClosList[strlen(routClosList)-1] = 0;	
    	else
    	{
    		age8481a_LOG_STATUS( vi, thisPtr, VI_ERROR_PARAMETER2);
    	}
    	if (old_error != instr_error_head(vi))
    	{ /* must have been bad channel list*/
    		age8481a_LOG_STATUS( vi, thisPtr, VI_ERROR_PARAMETER2);
    	}
    	free(cmd);
    }
    age8481a_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC age8481a_routClos_Q
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  age8481a_routClos_Q returns
 *            the current state of the channel queried.
 *            The channel is in the form ssrrcc where ss = card number
 *           (01-99), rr = matrix row number (0-3), and cc = matrix column
 *           number (00-31). The function returns 1 if the channel is
 *           closed or returns 0 if the channel is open.
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViInt32 channel
 * IN        
 *            Numeric value of the channel to be queried in the form ssrrcc
 *           where ss = card number (01-99), rr = matrix row number (0-3), 
 *           and cc = matrix column number (00-31).
 * 
 *      MAX = age8481a_CHANNEL_MAX   999999
 *      MIN = age8481a_CHANNEL_MIN   100
 * 
 * PARAM 3 : ViPBoolean routClos
 * OUT       
 *           Returns the state of the channel queried.
 *           0 = Open channel
 *           1 = Closed channel
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "age8481a_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
ViStatus _VI_FUNC age8481a_routClos_Q(INST vi,
									  ViInt32 channel,
									  ViPBoolean routClos)
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct age8481a_globals *thisPtr;

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViPAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViPAddr) &thisPtr);
    }
    if (VI_SUCCESS > errStatus)
	{
		age8481a_LOG_STATUS( vi, 0, errStatus );
	}

    age8481a_DEBUG_CHK_THIS( vi, thisPtr );
    age8481a_CDE_INIT( "age8481a_routClos_Q" );

    /* Perform Error Checking on Each Parameter */
    age8481a_CHK_LONG_RANGE(channel, age8481a_CHANNEL_MIN,
							age8481a_CHANNEL_MAX, VI_ERROR_PARAMETER2);

    if (thisPtr->e1406)
    {
        char str[10];
    
        *str = 0;
        thisPtr->blockSrqIO = VI_TRUE;
        errStatus = viPrintf(vi,"CLOS? (@%ld)\n",channel);
        if (errStatus < VI_SUCCESS)
        {
            age8481a_LOG_STATUS( vi, thisPtr, errStatus );
        }
        errStatus = viScanf(vi,"%t",str);
        *routClos = (*str=='1');
        if (errStatus < VI_SUCCESS)
        {
            age8481a_LOG_STATUS( vi, thisPtr, errStatus );
        }
    }
    else
    {
    	char str[10];
    	long old_error;
    
    	*str = 0;
    	old_error = instr_error_head(vi);
    	{{ struct {short p1_type; char p1_type_pad[6]; double p1[1];} in_;struct {double p1[1];} out_;
//#line 4246 "age8481a.cs"
HPSL_CHANNEL_LIST bl_1[1];
//#line 4246 "age8481a.cs"
in_.p1_type= 5;
//#line 4246 "age8481a.cs"
bl_1[0].number=channel;*(HPSL_CHANNEL_PTR*)in_.p1=bl_1;bl_1[0].type= 1;bl_1[0].next= 0;
//#line 4246 "age8481a.cs"
{extern sw_clos_q();if (!instr_query(vi,sw_clos_q,&in_,&out_)){
//#line 4246 "age8481a.cs"
(void)strcpy((str),*(HPSL_STRING*)out_.p1);}}}}
    	*routClos = (*str=='1');
    	if (!*str || old_error != instr_error_head(vi))
    	{ /* must have been bad channel list*/
    		age8481a_LOG_STATUS( vi, thisPtr, VI_ERROR_PARAMETER2);
    	}
    }
    age8481a_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC age8481a_routOpen
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  age8481a_routOpen opens a matrix channel specified.
 *            The channel is in the form ssrrcc where ss = card number
 *           (01-99), rr = matrix row number (0-3), and cc = matrix 
 *           column number (00-31).
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViInt32 channel
 * IN        
 *            Numeric value of the channel to be opened in the form ssrrcc
 *           where ss = card number (01-99), rr = matrix row number (0-3),
 *           and cc = matrix column number (00-31).
 * 
 *      MAX = age8481a_CHANNEL_MAX   999999
 *      MIN = age8481a_CHANNEL_MIN   100
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "age8481a_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
ViStatus _VI_FUNC age8481a_routOpen(INST vi,
									ViInt32 channel)
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct age8481a_globals *thisPtr;

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViPAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViPAddr) &thisPtr);
    }
    if (VI_SUCCESS > errStatus)
	{
		age8481a_LOG_STATUS( vi, 0, errStatus );
	}

    age8481a_DEBUG_CHK_THIS( vi, thisPtr );
    age8481a_CDE_INIT( "age8481a_routOpen" );

    /* Perform Error Checking on Each Parameter */
    age8481a_CHK_LONG_RANGE(channel, age8481a_CHANNEL_MIN,
							age8481a_CHANNEL_MAX, VI_ERROR_PARAMETER2);

    if (thisPtr->e1406)
    {
        errStatus = viPrintf(vi,"OPEN (@%ld)\n",channel);
        if (errStatus < VI_SUCCESS)
        {
            age8481a_LOG_STATUS( vi, thisPtr, errStatus );
        }
    }
    else
    {
    	long old_error;
    
    	old_error = instr_error_head(vi);
    	{{ struct {short p1_type; char p1_type_pad[6]; double p1[1];} in_;
//#line 4325 "age8481a.cs"
HPSL_CHANNEL_LIST bl_1[1];
//#line 4325 "age8481a.cs"
in_.p1_type= 5;
//#line 4325 "age8481a.cs"
bl_1[0].number=channel;*(HPSL_CHANNEL_PTR*)in_.p1=bl_1;bl_1[0].type= 1;bl_1[0].next= 0;
//#line 4325 "age8481a.cs"
{extern sw_open();instr_send(vi,sw_open,&in_);}}}
    	if (old_error != instr_error_head(vi))
    	{ /* must have been bad channel list*/
    		age8481a_LOG_STATUS( vi, thisPtr, VI_ERROR_PARAMETER2);
    	}
    }
    age8481a_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC age8481a_routOpenList
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  age8481a_routOpenList opens the matrix channels specified
 *            in the channelList.
 *            The channelList is in the form "ssrrcc", "ssrrcc,ssrrcc",
 *            or "ssrrcc:ccrc" where ss = card number (01-99),
 *            rr = matrix row number (0-3), and cc = matrix column number
 *            (00-31).
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViString channelList
 * IN        
 *            Channel list of the channels to be opened. The channelList is
 *           in the form The channelList is in the form "ssrrcc",
 *           "ssrrcc,ssrrcc", or "ssrrcc:ccrc" where ss = card number
 *           (01-99), rr = matrix row number (0-3), and cc = matrix column
 *           number (00-31).
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "age8481a_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
ViStatus _VI_FUNC age8481a_routOpenList(INST vi,
										ViString channelList)
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct age8481a_globals *thisPtr;

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViPAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViPAddr) &thisPtr);
    }
    if (VI_SUCCESS > errStatus)
	{
		age8481a_LOG_STATUS( vi, 0, errStatus );
	}

    age8481a_DEBUG_CHK_THIS( vi, thisPtr );
    age8481a_CDE_INIT( "age8481a_routOpenList" );

    if (thisPtr->e1406)
    {
        errStatus = viPrintf(vi,"OPEN (@%s)\n",channelList);
        if (errStatus < VI_SUCCESS)
        {
            age8481a_LOG_STATUS( vi, thisPtr, errStatus );
        }
    }
    else
    {
    	char *cmd = malloc(strlen(channelList)+20);
    	long old_error;
    
    	if (!cmd)
    	{
    		age8481a_CDE_ERROR( VI_ERROR_ALLOC );
    		age8481a_LOG_STATUS( vi, thisPtr, VI_ERROR_ALLOC );
    	}
    	strcpy(cmd, "OPEN (@");
    	strcat(cmd, channelList);
    	strcat(cmd, ")");
    	old_error = instr_error_head(vi);
    	cscpi_exe(vi, cmd, strlen(cmd), 0, 0);
    	free(cmd);
    	if (old_error != instr_error_head(vi))
    	{ /* must have been bad channel list*/
    		age8481a_LOG_STATUS( vi, thisPtr, VI_ERROR_PARAMETER2);
    	}
    }
    age8481a_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC age8481a_routOpenList_Q
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  age8481a_routOpenList_Q returns the
 *            current state of the channels queried.
 *            The channelList is in the form "ssrrcc", "ssrrcc,ssrrcc",
 *            or "ssrrcc:ccrc" where ss = card number (01-99),
 *            rr = matrix row number (0-3), and cc = matrix column number
 *            (00-31). The function returns a comma separated list of 1's
 *            and 0's, 1 for each open channel and 0 for each closed channel.
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViString channelList
 * IN        
 *            Channel list of the channels to be queried. The channelList is
 *           in the form The channelList is in the form "ssrrcc",
 *           "ssrrcc,ssrrcc", or "ssrrcc:ccrc" where ss = card number
 *           (01-99), rr = matrix row number (00-03), and cc = matrix column
 *           number (00-31).
 * 
 * PARAM 3 : ViChar _VI_FAR routOpenList[]
 * OUT       
 *           A comma separated list of 1's and 0's,
 *           1 for each open channel and 0 for closed channel.
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "age8481a_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
ViStatus _VI_FUNC age8481a_routOpenList_Q(INST vi,
										  ViString channelList,
										  ViChar _VI_FAR routOpenList[])
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct age8481a_globals *thisPtr;

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViPAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViPAddr) &thisPtr);
    }
    if (VI_SUCCESS > errStatus)
	{
		age8481a_LOG_STATUS( vi, 0, errStatus );
	}

    age8481a_DEBUG_CHK_THIS( vi, thisPtr );
    age8481a_CDE_INIT( "age8481a_routOpenList_Q" );

    if (thisPtr->e1406)
    {
        thisPtr->blockSrqIO = VI_TRUE;
        errStatus = viPrintf(vi,"OPEN? (@%s)\n",channelList);
        if (errStatus < VI_SUCCESS)
        {
            age8481a_LOG_STATUS( vi, thisPtr, errStatus );
        }
        errStatus = viScanf(vi,"%t",routOpenList);
        if (errStatus < VI_SUCCESS)
        {
            age8481a_LOG_STATUS( vi, thisPtr, errStatus );
        }
        /* remove trailing newline */
        if (routOpenList[0])
    	routOpenList[strlen(routOpenList)-1] = 0;	
        else
        {
    	age8481a_LOG_STATUS( vi, thisPtr, VI_ERROR_PARAMETER2);
        }
    }
    else
    {
    	char *cmd = malloc(strlen(channelList)+20);
    	long old_error;
    
    	if (!cmd)
    	{
    		age8481a_CDE_ERROR( VI_ERROR_ALLOC );
    		age8481a_LOG_STATUS( vi, thisPtr, VI_ERROR_ALLOC );
    	}
    	strcpy(cmd, "OPEN? (@");
    	strcat(cmd, channelList);
    	strcat(cmd, ")");
    	old_error = instr_error_head(vi);
    	cscpi_exe(vi, cmd, strlen(cmd), routOpenList, 32700);
    	/* remove trailing newline */
    	if (routOpenList[0])
    		routOpenList[strlen(routOpenList)-1] = 0;	
    	else
    	{
    		age8481a_LOG_STATUS( vi, thisPtr, VI_ERROR_PARAMETER2);
    	}
    	if (old_error != instr_error_head(vi))
    	{ /* must have been bad channel list*/
    		age8481a_LOG_STATUS( vi, thisPtr, VI_ERROR_PARAMETER2);
    	}
    	free(cmd);
    }
    age8481a_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC age8481a_routOpen_Q
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  age8481a_routOpen_Q returns the
 *            current state of the channel queried.
 *            The channel is in the form ssrrcc where ss = card number
 *           (01-99), rr = matrix row number (00-03), and cc = matrix
 *           column number (00-31 for 1467). The function returns 1 if the
 *           channel is open or returns 0 if the channel is closed.
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViInt32 channel
 * IN        
 *            Numeric value of the channel to be queried in the form ssrrcc
 *           where ss = card number (01-99), rr = matrix row number (00-03),
 *           and cc = matrix column number (00-31).
 * 
 *      MAX = age8481a_CHANNEL_MAX   999999
 *      MIN = age8481a_CHANNEL_MIN   100
 * 
 * PARAM 3 : ViPBoolean routOpen
 * OUT       
 *           Returns the state of the channel queried.
 *           0 = Closed channel
 *           1 = Open channel
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "age8481a_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
ViStatus _VI_FUNC age8481a_routOpen_Q(INST vi,
									  ViInt32 channel,
									  ViPBoolean routOpen)
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct age8481a_globals *thisPtr;

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViPAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViPAddr) &thisPtr);
    }
    if (VI_SUCCESS > errStatus)
	{
		age8481a_LOG_STATUS( vi, 0, errStatus );
	}

    age8481a_DEBUG_CHK_THIS( vi, thisPtr );
    age8481a_CDE_INIT( "age8481a_routOpen_Q" );

    /* Perform Error Checking on Each Parameter */
    age8481a_CHK_LONG_RANGE(channel, age8481a_CHANNEL_MIN,
							age8481a_CHANNEL_MAX, VI_ERROR_PARAMETER2);

    if (thisPtr->e1406)
    {
        char str[10];
    
        *str = 0;
        thisPtr->blockSrqIO = VI_TRUE;
        errStatus = viPrintf(vi,"OPEN? (@%ld)\n",channel);
        if (errStatus < VI_SUCCESS)
        {
            age8481a_LOG_STATUS( vi, thisPtr, errStatus );
        }
        errStatus = viScanf(vi,"%t",str);
        if (errStatus < VI_SUCCESS)
        {
            age8481a_LOG_STATUS( vi, thisPtr, errStatus );
        }
        *routOpen = (*str=='1');
    }
    else
    {
    	char str[10];
    	long old_error;
    
    	*str = 0;
    	old_error = instr_error_head(vi);
    	{{ struct {short p1_type; char p1_type_pad[6]; double p1[1];} in_;struct {double p1[1];} out_;
//#line 4621 "age8481a.cs"
HPSL_CHANNEL_LIST bl_1[1];
//#line 4621 "age8481a.cs"
in_.p1_type= 5;
//#line 4621 "age8481a.cs"
bl_1[0].number=channel;*(HPSL_CHANNEL_PTR*)in_.p1=bl_1;bl_1[0].type= 1;bl_1[0].next= 0;
//#line 4621 "age8481a.cs"
{extern sw_open_q();if (!instr_query(vi,sw_open_q,&in_,&out_)){
//#line 4621 "age8481a.cs"
(void)strcpy((str),*(HPSL_STRING*)out_.p1);}}}}
    	*routOpen = (*str=='1');
    	if (!*str || old_error != instr_error_head(vi))
    	{ /* must have been bad channel list*/
    		age8481a_LOG_STATUS( vi, thisPtr, VI_ERROR_PARAMETER2);
    	}
    }
    age8481a_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC age8481a_routScanList
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  age8481a_routScanList defines the
 *            channels to be scanned.
 *            The channelList is in the form "ssrrcc", "ssrrcc,ssrrcc",
 *            or "ssrrcc:ssrrcc" where ss = card number (01-99),
 *            rr = matrix row number (00-03), and cc = matrix column 
 *            number (00-31).
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViString channelList
 * IN        
 *            Channel list of the channels to be scanned. The channelList is
 *           in the form The channelList is in the form "ssrrcc",
 *           "ssrrcc,ssrrcc", or "ssrrcc:ccrc" where ss = card number
 *           (01-99), rr = matrix row number (00-03), and cc = matrix column
 *           number (00-31).
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "age8481a_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
ViStatus _VI_FUNC age8481a_routScanList(INST vi,
										ViString channelList)
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct age8481a_globals *thisPtr;

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViPAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViPAddr) &thisPtr);
    }
    if (VI_SUCCESS > errStatus)
	{
		age8481a_LOG_STATUS( vi, 0, errStatus );
	}

    age8481a_DEBUG_CHK_THIS( vi, thisPtr );
    age8481a_CDE_INIT( "age8481a_routScanList" );

    if (thisPtr->e1406)
    {
        errStatus = viPrintf(vi,"SCAN (@%s)\n",channelList);
        if (errStatus < VI_SUCCESS)
        {
            age8481a_LOG_STATUS( vi, thisPtr, errStatus );
        }
    }
    else
    {
    	char *cmd = malloc(strlen(channelList)+20);
    	long old_error;
    
    	if (!cmd)
    	{
    		age8481a_CDE_ERROR( VI_ERROR_ALLOC );
    		age8481a_LOG_STATUS( vi, thisPtr, VI_ERROR_ALLOC );
    	}
    	strcpy(cmd, "SCAN (@");
    	strcat(cmd, channelList);
    	strcat(cmd, ")");
    	old_error = instr_error_head(vi);
    	cscpi_exe(vi, cmd, strlen(cmd), 0, 0);
    	if (old_error != instr_error_head(vi))
    	{ /* must have been bad channel list*/
    		age8481a_LOG_STATUS( vi, thisPtr, VI_ERROR_PARAMETER2);
    	}
    	free(cmd);
    }
    age8481a_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC age8481a_systCdes_Q
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  age8481a_systCdes_Q returns
 *            the description of a selected module (card) in a switchbox.
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViInt16 card
 * IN        
 *            Numeric value of the module (card) to be queried in a
 *           switchbox.
 * 
 *      MAX = age8481a_CARD_MAX   99
 *      MIN = age8481a_CARD_MIN   1
 * 
 * PARAM 3 : ViChar _VI_FAR systCdes[]
 * OUT       
 *            Returns the description of the selected module (card).
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "age8481a_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
ViStatus _VI_FUNC age8481a_systCdes_Q(INST vi,
									  ViInt16 card,
									  ViChar _VI_FAR systCdes[])
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct age8481a_globals *thisPtr;

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViPAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViPAddr) &thisPtr);
    }
    if (VI_SUCCESS > errStatus)
	{
		age8481a_LOG_STATUS( vi, 0, errStatus );
	}

    age8481a_DEBUG_CHK_THIS( vi, thisPtr );
    age8481a_CDE_INIT( "age8481a_systCdes_Q" );

    /* Perform Error Checking on Each Parameter */
    age8481a_CHK_INT_RANGE(card, age8481a_CARD_MIN,
						   age8481a_CARD_MAX, VI_ERROR_PARAMETER2);

    *systCdes = 0;
    if (thisPtr->e1406)
    {
        thisPtr->blockSrqIO = VI_TRUE;
        errStatus = viPrintf(vi,"SYST:CDES? %d\n",card); 
        if (errStatus < VI_SUCCESS)
        {
            age8481a_LOG_STATUS( vi, thisPtr, errStatus );
        }
        errStatus = viScanf(vi,"%t",systCdes);
        if (errStatus < VI_SUCCESS)
        {
            age8481a_LOG_STATUS( vi, thisPtr, errStatus );
        }
        /* remove trailing newline */
        if (systCdes[0])
    	systCdes[strlen(systCdes)-1] = 0;	
        else
        {
			age8481a_LOG_STATUS( vi, thisPtr, VI_ERROR_PARAMETER2);
        }
    }
    else
    {
    	{{ struct {short p1_type; char p1_type_pad[6]; double p1[1];} in_;struct {double p1[1];} out_;
//#line 4798 "age8481a.cs"
in_.p1_type= 0;((HPSL_INT16*)in_.p1)->num=(card);
//#line 4798 "age8481a.cs"
((HPSL_INT16*)in_.p1)->suffix=0;
//#line 4798 "age8481a.cs"
{extern sw_systcdes_q();if (!instr_query(vi,sw_systcdes_q,&in_,&out_)){
//#line 4798 "age8481a.cs"
(void)strcpy((systCdes),*(HPSL_STRING*)out_.p1);}}}}
    	if (!*systCdes)
    	{ /* must have been bad card*/
    		age8481a_LOG_STATUS( vi, thisPtr, VI_ERROR_PARAMETER2);
    	}
    }
    age8481a_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC age8481a_systCpon
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  age8481a_systCpon opens all
 *            channels of a selected or all modules (cards) in a switchbox.
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViInt16 card
 * IN        
 *            Numeric value of the module (card) to be reset in a switchbox.
 * 
 *      MAX = age8481a_CARD_MAX   99
 *      MIN = age8481a_CARD_MIN   1
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "age8481a_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
ViStatus _VI_FUNC age8481a_systCpon(INST vi,
									ViInt16 card)
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct age8481a_globals *thisPtr;

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViPAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViPAddr) &thisPtr);
    }
    if (VI_SUCCESS > errStatus)
	{
		age8481a_LOG_STATUS( vi, 0, errStatus );
	}

    age8481a_DEBUG_CHK_THIS( vi, thisPtr );
    age8481a_CDE_INIT( "age8481a_systCpon" );

    /* Perform Error Checking on Each Parameter */
    age8481a_CHK_INT_RANGE(card, age8481a_CARD_MIN,
						   age8481a_CARD_MAX, VI_ERROR_PARAMETER2);

    if (thisPtr->e1406)
    {
        errStatus = viPrintf(vi,"SYST:CPON %d\n",card);
        if (errStatus < VI_SUCCESS)
        {
            age8481a_LOG_STATUS( vi, thisPtr, errStatus );
        }
    }
    else
    {
    	long old_error;
    
    	old_error = instr_error_head(vi);
    	{{ struct {short p1_type; char p1_type_pad[6]; double p1[1];} in_;
//#line 4872 "age8481a.cs"
in_.p1_type= 0;((HPSL_INT16*)in_.p1)->num=(card);
//#line 4872 "age8481a.cs"
((HPSL_INT16*)in_.p1)->suffix=0;
//#line 4872 "age8481a.cs"
{extern sw_systcpon();instr_send(vi,sw_systcpon,&in_);}}}
    	if (old_error != instr_error_head(vi))
    	{ /* must have been card*/
    		age8481a_LOG_STATUS( vi, thisPtr, VI_ERROR_PARAMETER2);
    	}
    }
    age8481a_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC age8481a_systCtyp_Q
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  age8481a_systCtyp_Q returns the module
 *            (card) type of a selected module in a switchbox.
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViInt16 card
 * IN        
 *            Numeric value of the module (card) to be queried in a
 *           switchbox.
 * 
 *      MAX = age8481a_CARD_MAX   99
 *      MIN = age8481a_CARD_MIN   1
 * 
 * PARAM 3 : ViChar _VI_FAR systCtyp[]
 * OUT       
 *            Returns the module (card) type of the selected module.
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "age8481a_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
ViStatus _VI_FUNC age8481a_systCtyp_Q(INST vi,
									  ViInt16 card,
									  ViChar _VI_FAR systCtyp[])
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct age8481a_globals *thisPtr;

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViPAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViPAddr) &thisPtr);
    }
    if (VI_SUCCESS > errStatus)
	{
		age8481a_LOG_STATUS( vi, 0, errStatus );
	}

    age8481a_DEBUG_CHK_THIS( vi, thisPtr );
    age8481a_CDE_INIT( "age8481a_systCtyp_Q" );

    /* Perform Error Checking on Each Parameter */
    age8481a_CHK_INT_RANGE(card, age8481a_CARD_MIN,
						   age8481a_CARD_MAX, VI_ERROR_PARAMETER2);

    *systCtyp = 0;
    if (thisPtr->e1406)
    {
        thisPtr->blockSrqIO = VI_TRUE;
        errStatus = viPrintf(vi,"SYST:CTYP? %d\n",card); 
        if (errStatus < VI_SUCCESS)
        {
            age8481a_LOG_STATUS( vi, thisPtr, errStatus );
        }
        errStatus = viScanf(vi,"%t",systCtyp);
        if (errStatus < VI_SUCCESS)
        {
            age8481a_LOG_STATUS( vi, thisPtr, errStatus );
        }
        /* remove trailing newline */
        if (systCtyp[0])
    	systCtyp[strlen(systCtyp)-1] = 0;	
        else
        {
    	age8481a_LOG_STATUS( vi, thisPtr, VI_ERROR_PARAMETER2);
        }
    }
    else
    {
    	{{ struct {short p1_type; char p1_type_pad[6]; double p1[1];} in_;struct {double p1[1];} out_;
//#line 4963 "age8481a.cs"
in_.p1_type= 0;((HPSL_INT16*)in_.p1)->num=(card);
//#line 4963 "age8481a.cs"
((HPSL_INT16*)in_.p1)->suffix=0;
//#line 4963 "age8481a.cs"
{extern sw_systctyp_q();if (!instr_query(vi,sw_systctyp_q,&in_,&out_)){
//#line 4963 "age8481a.cs"
(void)memcpy((systCtyp),(*(HPSL_ARB_ASCII*)out_.p1).buffer,(*(HPSL_ARB_ASCII*)out_.p1).length);
//#line 4963 "age8481a.cs"
(systCtyp)[(*(HPSL_ARB_ASCII*)out_.p1).length]='\0';}}}}
    	if (!*systCtyp)
    	{ /* must have been bad card*/
    		age8481a_LOG_STATUS( vi, thisPtr, VI_ERROR_PARAMETER2);
    	}
    }
    age8481a_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC age8481a_trigSour
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  age8481a_trigSour specifies
 *            the trigger source to advance the channel list during scanning.
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViInt16 trigSour
 * IN        
 *            The trigger source type.
 *            The types are defined as macros and are shown below:
 * 
 *      Macro Name                   Value  Description
 *      -----------------------------------------------------------
 *      age8481a_TRIG_SOUR_BUS            0  Software Trigger
 *      age8481a_TRIG_SOUR_ECLT0          1  ECLTRG0
 *      age8481a_TRIG_SOUR_ECLT1          2  ECLTRG1
 *      age8481a_TRIG_SOUR_HOLD           3  Hold
 *      age8481a_TRIG_SOUR_IMM            4  Immediate
 *      age8481a_TRIG_SOUR_TTLT0          5  TTLTRG0
 *      age8481a_TRIG_SOUR_TTLT1          6  TTLTRG1
 *      age8481a_TRIG_SOUR_TTLT2          7  TTLTRG2
 *      age8481a_TRIG_SOUR_TTLT3          8  TTLTRG3
 *      age8481a_TRIG_SOUR_TTLT4          9  TTLTRG4
 *      age8481a_TRIG_SOUR_TTLT5         10  TTLTRG5
 *      age8481a_TRIG_SOUR_TTLT6         11  TTLTRG6
 *      age8481a_TRIG_SOUR_TTLT7         12  TTLTRG7
 *      age8481a_TRIG_SOUR_EXT           13  Trig In BNC
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "age8481a_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
static const char * const age8481a_trigSour_trigSour_a[] = {"BUS","ECLT0",
        "ECLT1","HOLD","IMM","TTLT0","TTLT1","TTLT2","TTLT3","TTLT4",
        "TTLT5","TTLT6","TTLT7","EXT",0};

ViStatus _VI_FUNC age8481a_trigSour(INST vi,
									ViInt16 trigSour)
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct age8481a_globals *thisPtr;

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViPAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViPAddr) &thisPtr);
    }
    if (VI_SUCCESS > errStatus)
	{
		age8481a_LOG_STATUS( vi, 0, errStatus );
	}

    age8481a_DEBUG_CHK_THIS( vi, thisPtr );
    age8481a_CDE_INIT( "age8481a_trigSour" );

    /* Perform Error Checking on Each Parameter */
    age8481a_CHK_ENUM(trigSour,13,VI_ERROR_PARAMETER2);
    if (thisPtr->e1406)
    {
        errStatus = viPrintf(vi,"TRIG:SOUR %s\n",age8481a_trigSour_trigSour_a[trigSour]);
        if (VI_SUCCESS > errStatus)
        {
            age8481a_LOG_STATUS( vi, thisPtr, errStatus );
        }
    }
    else
    {
        {{ struct {short p1_type; char p1_type_pad[6]; double p1[1];} in_;
//#line 5051 "age8481a.cs"
extern CSCPI_IMPORT void *Eswitch_enum_BUSDBUS25[];char f_=0;
//#line 5051 "age8481a.cs"
in_.p1_type= 2;*(HPSL_ENUM*)in_.p1=char_to_enum(Eswitch_enum_BUSDBUS25,age8481a_trigSour_trigSour_a[trigSour],vi, &f_);
//#line 5051 "age8481a.cs"
if (!f_) {extern sw_trigsour();instr_send(vi,sw_trigsour,&in_);}}}
    }
    age8481a_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC age8481a_trigSour_Q
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  age8481a_trigSour_Q returns the current trigger source for
 *            the switchbox.
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViPInt16 trigSour
 * OUT       
 *            Returns the current trigger source type.
 *            The types are defined as macros and are shown below:
 * 
 *      Macro Name                   Value  Description
 *      -----------------------------------------------------------
 *      age8481a_TRIG_SOUR_BUS            0  Software Trigger
 *      age8481a_TRIG_SOUR_ECLT0          1  ECLTRG0
 *      age8481a_TRIG_SOUR_ECLT1          2  ECLTRG1
 *      age8481a_TRIG_SOUR_HOLD           3  Hold
 *      age8481a_TRIG_SOUR_IMM            4  Immediate
 *      age8481a_TRIG_SOUR_TTLT0          5  TTLTRG0
 *      age8481a_TRIG_SOUR_TTLT1          6  TTLTRG1
 *      age8481a_TRIG_SOUR_TTLT2          7  TTLTRG2
 *      age8481a_TRIG_SOUR_TTLT3          8  TTLTRG3
 *      age8481a_TRIG_SOUR_TTLT4          9  TTLTRG4
 *      age8481a_TRIG_SOUR_TTLT5         10  TTLTRG5
 *      age8481a_TRIG_SOUR_TTLT6         11  TTLTRG6
 *      age8481a_TRIG_SOUR_TTLT7         12  TTLTRG7
 *      age8481a_TRIG_SOUR_EXT           13  Trig In BNC
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "age8481a_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
static const char * const age8481a_trigSour_Q_trigSour_a[] = {"BUS",
        "ECLT0","ECLT1","HOLD","IMM","TTLT0","TTLT1","TTLT2","TTLT3",
        "TTLT4","TTLT5","TTLT6","TTLT7","EXT",0};

ViStatus _VI_FUNC age8481a_trigSour_Q(INST vi,
									  ViPInt16 trigSour)
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct age8481a_globals *thisPtr;
    char trigSour_str[32];

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViPAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViPAddr) &thisPtr);
    }
    if (VI_SUCCESS > errStatus)
	{
		age8481a_LOG_STATUS( vi, 0, errStatus );
	}

    age8481a_DEBUG_CHK_THIS( vi, thisPtr );
    age8481a_CDE_INIT( "age8481a_trigSour_Q" );

    if (thisPtr->e1406)
    {
        thisPtr->blockSrqIO = VI_TRUE;
        errStatus = viPrintf(vi,"TRIG:SOUR?\n");
        if (VI_SUCCESS > errStatus)
        {
            age8481a_LOG_STATUS( vi, thisPtr, errStatus );
        }
        errStatus = viScanf(vi,"%s%*t",trigSour_str);
        if (VI_SUCCESS > errStatus)
        {
            age8481a_LOG_STATUS( vi, thisPtr, errStatus );
        }
    }
    else
    {
        {{ struct {double p1[1];} out_;
//#line 5140 "age8481a.cs"
extern CSCPI_IMPORT void *Eswitch_enum_BUSDBUS25[];
//#line 5140 "age8481a.cs"
{extern sw_trigsour_q();if (!instr_query(vi,sw_trigsour_q,(void*)0,&out_)){
//#line 5140 "age8481a.cs"
enum_to_char(trigSour_str, Eswitch_enum_BUSDBUS25, *(HPSL_ENUM*)out_.p1);}}}}
    }
    errStatus = age8481a_findIndex(thisPtr,
								   age8481a_trigSour_Q_trigSour_a,
								   trigSour_str, trigSour);
    if (VI_SUCCESS > errStatus)
	{
		age8481a_LOG_STATUS( vi, thisPtr, errStatus );
	}

    age8481a_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC age8481a_interTimer
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  age8481a_interTimer sets the interrupt timer.
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViInt16 card
 * IN        
 *            Numeric value of the module (card) to be disabled in a
 *           switchbox.
 * 
 *      MAX = age8481a_CARD_MAX   99
 *      MIN = age8481a_CARD_MIN   1
 *
 * PARAM 3 : ViReal64 Timer
 * OUT
 *            sets the value of the interrupt timer(s).
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "age8481a_error_message".
 * 
 *-----------------------------------------------------------------------------
 */

ViStatus _VI_FUNC age8481a_interTimer(INST vi,
									  ViInt16 card,
									  ViReal64 timer)
{
	ViUInt16 intf;
	ViStatus errStatus = 0;
	struct age8481a_globals *thisPtr;

	viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
	if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
	{
		errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViPAddr) &thisPtr);
	}
	else
	{
		errStatus = instr_getdata(vi, (ViPAddr) &thisPtr);
	}
	if (VI_SUCCESS > errStatus)
	{
		age8481a_LOG_STATUS( vi, 0, errStatus );
	}

	age8481a_DEBUG_CHK_THIS( vi, thisPtr );
	age8481a_CDE_INIT( "age8481a_interTimer" );

	/* Perform Error Checking on Each Parameter */
	age8481a_CHK_INT_RANGE(card, age8481a_CARD_MIN,
						   age8481a_CARD_MAX, VI_ERROR_PARAMETER2);

	if (thisPtr->e1406)
	{
		errStatus = viPrintf(vi,":DIAG:INT:TIMER %d,%f\n", card,timer);
		if (VI_SUCCESS > errStatus)
		{
			age8481a_LOG_STATUS( vi, thisPtr, errStatus );
		}
	}
	else
	{
		long old_error;
		old_error = instr_error_head(vi);
		{{ struct {short p1_type; char p1_type_pad[6]; double p1[1];short p2_type; char p2_type_pad[6]; double p2[1];} in_;
//#line 5223 "age8481a.cs"
in_.p1_type= 0;((HPSL_INT16*)in_.p1)->num=(card);
//#line 5223 "age8481a.cs"
((HPSL_INT16*)in_.p1)->suffix=0;
//#line 5223 "age8481a.cs"
in_.p2_type= 0;((HPSL_FLOAT32*)in_.p2)->num=(timer);
//#line 5223 "age8481a.cs"
((HPSL_FLOAT32*)in_.p2)->suffix=0;
//#line 5223 "age8481a.cs"
{extern sw_diag_inttimer();instr_send(vi,sw_diag_inttimer,&in_);}}}
		if (old_error != instr_error_head(vi))
			age8481a_LOG_STATUS(vi, thisPtr, VI_ERROR_PARAMETER2);
	}
	age8481a_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC age8481a_interTimer_Q
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  age8481a_interTimer_Q queries the interrupt timer.
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViInt16 card
 * IN        
 *            Numeric value of the module (card) to be disabled in a
 *           switchbox.
 * 
 *      MAX = age8481a_CARD_MAX   99
 *      MIN = age8481a_CARD_MIN   1
 *
 * PARAM 3 : ViPReal64 delayTime
 * OUT
 *            returns the value of the interrupt timer(s).
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "age8481a_error_message".
 * 
 *-----------------------------------------------------------------------------
 */

ViStatus _VI_FUNC age8481a_interTimer_Q(INST vi,
									    ViInt16 card,
										ViPReal64 timer)
{
	ViUInt16 intf;
	ViStatus errStatus = 0;
	struct age8481a_globals *thisPtr;

	viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
	if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
	{
		errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViPAddr) &thisPtr);
	}
	else
	{
		errStatus = instr_getdata(vi, (ViPAddr) &thisPtr);
	}
	if (VI_SUCCESS > errStatus)
	{
		age8481a_LOG_STATUS( vi, 0, errStatus );
	}

	age8481a_DEBUG_CHK_THIS( vi, thisPtr );
	age8481a_CDE_INIT( "age8481a_interTimer_Q" );

	/* Perform Error Checking on Each Parameter */
	age8481a_CHK_INT_RANGE(card, age8481a_CARD_MIN,
						   age8481a_CARD_MAX, VI_ERROR_PARAMETER2);

	if (thisPtr->e1406)
	{
		errStatus = viPrintf(vi,":DIAG:INT:TIMER? %d\n", card);
		if (VI_SUCCESS > errStatus)
		{
			age8481a_LOG_STATUS( vi, thisPtr, errStatus );
		}
		errStatus = viScanf(vi,"%lf%*t",timer);
		if (VI_SUCCESS > errStatus)
		{
			age8481a_LOG_STATUS( vi, thisPtr, errStatus );
		}
	}
	else
	{
		long old_error;
		old_error = instr_error_head(vi);
		{{ struct {short p1_type; char p1_type_pad[6]; double p1[1];} in_;struct {double p1[1];} out_;
//#line 5305 "age8481a.cs"
in_.p1_type= 0;((HPSL_INT16*)in_.p1)->num=(card);
//#line 5305 "age8481a.cs"
((HPSL_INT16*)in_.p1)->suffix=0;
//#line 5305 "age8481a.cs"
{extern sw_diag_inttimer_q();if (!instr_query(vi,sw_diag_inttimer_q,&in_,&out_)){
//#line 5305 "age8481a.cs"
*timer=(*(HPSL_FLOAT32*)out_.p1).num;}}}}
		if (old_error != instr_error_head(vi))
			age8481a_LOG_STATUS(vi, thisPtr, VI_ERROR_PARAMETER2);
	}

	age8481a_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC age8481a_interLine
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  age8481a_interTimer sets the interrupt line.
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViInt16 card
 * IN        
 *            Numeric value of the module (card) to be disabled in a
 *           switchbox.
 * 
 *      MAX = age8481a_CARD_MAX   99
 *      MIN = age8481a_CARD_MIN   1
 *
 * PARAM 3 : ViInt16 line
 * OUT
 *            sets the interrupt line.
 *
 *		MAX = age8481a_INTERRUPT_LINE_MAX	7
 *		MIN = age8481a_INTERRUPT_LINE_MIN	0
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "age8481a_error_message".
 * 
 *-----------------------------------------------------------------------------
 */

ViStatus _VI_FUNC age8481a_interLine(INST vi,
									 ViInt16 card,
									 ViInt16 line)
{
	ViUInt16 intf;
	ViStatus errStatus = 0;
	struct age8481a_globals *thisPtr;

	viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
	if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
	{
		errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViPAddr) &thisPtr);
	}
	else
	{
		errStatus = instr_getdata(vi, (ViPAddr) &thisPtr);
	}
	if (VI_SUCCESS > errStatus)
	{
		age8481a_LOG_STATUS( vi, 0, errStatus );
	}

	age8481a_DEBUG_CHK_THIS( vi, thisPtr );
	age8481a_CDE_INIT( "age8481a_interTimer" );

	/* Perform Error Checking on Each Parameter */
	age8481a_CHK_INT_RANGE(card, age8481a_CARD_MIN,
						   age8481a_CARD_MAX, VI_ERROR_PARAMETER2);
	age8481a_CHK_INT_RANGE(line, age8481a_INTERRUPT_LINE_MIN,
						   age8481a_INTERRUPT_LINE_MAX, VI_ERROR_PARAMETER3);

	if (thisPtr->e1406)
	{
		errStatus = viPrintf(vi,":DIAG:INT:LINE %d,%d\n", card,line);
		if (VI_SUCCESS > errStatus)
		{
			age8481a_LOG_STATUS( vi, thisPtr, errStatus );
		}
	}
	else
	{
		long old_error;
		old_error = instr_error_head(vi);
		{{ struct {short p1_type; char p1_type_pad[6]; double p1[1];short p2_type; char p2_type_pad[6]; double p2[1];} in_;
//#line 5388 "age8481a.cs"
in_.p1_type= 0;((HPSL_INT16*)in_.p1)->num=(card);
//#line 5388 "age8481a.cs"
((HPSL_INT16*)in_.p1)->suffix=0;
//#line 5388 "age8481a.cs"
in_.p2_type= 0;((HPSL_INT16*)in_.p2)->num=(line);
//#line 5388 "age8481a.cs"
((HPSL_INT16*)in_.p2)->suffix=0;
//#line 5388 "age8481a.cs"
{extern sw_diag_intline();instr_send(vi,sw_diag_intline,&in_);}}}
		if (old_error != instr_error_head(vi))
			age8481a_LOG_STATUS(vi, thisPtr, VI_ERROR_PARAMETER2);
	}

	age8481a_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC age8481a_interLine_Q
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  age8481a_interTimer_Q queries the interrupt line.
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViInt16 card
 * IN        
 *            Numeric value of the module (card) to be disabled in a
 *           switchbox.
 * 
 *      MAX = age8481a_CARD_MAX   99
 *      MIN = age8481a_CARD_MIN   1
 *
 * PARAM 3 : ViPInt16 line
 * OUT
 *            returns the value of the interrupt line.
 *		MAX = age8481a_INTERRUPT_LINE_MAX	7
 *		MIN = age8481a_INTERRUPT_LINE_MIN	0
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "age8481a_error_message".
 * 
 *-----------------------------------------------------------------------------
 */

ViStatus _VI_FUNC age8481a_interLine_Q(INST vi,
									   ViInt16 card,
									   ViPInt16 line)
{
	ViUInt16 intf;
	ViStatus errStatus = 0;
	struct age8481a_globals *thisPtr;

	viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
	if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
	{
		errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViPAddr) &thisPtr);
	}
	else
	{
		errStatus = instr_getdata(vi, (ViPAddr) &thisPtr);
	}
	if (VI_SUCCESS > errStatus)
	{
		age8481a_LOG_STATUS( vi, 0, errStatus );
	}

	age8481a_DEBUG_CHK_THIS( vi, thisPtr );
	age8481a_CDE_INIT( "age8481a_interTimer_Q" );

	/* Perform Error Checking on Each Parameter */
	age8481a_CHK_INT_RANGE(card, age8481a_CARD_MIN,
						   age8481a_CARD_MAX, VI_ERROR_PARAMETER2);

	if (thisPtr->e1406)
	{
		errStatus = viPrintf(vi,":DIAG:INT:LINE? %d\n", card);
		if (VI_SUCCESS > errStatus)
		{
			age8481a_LOG_STATUS( vi, thisPtr, errStatus );
		}
		errStatus = viScanf(vi,"%hd%*t",line);
		if (VI_SUCCESS > errStatus)
		{
			age8481a_LOG_STATUS( vi, thisPtr, errStatus );
		}
	}
	else
	{
		long old_error;
		old_error = instr_error_head(vi);
		{{ struct {short p1_type; char p1_type_pad[6]; double p1[1];} in_;struct {double p1[1];} out_;
//#line 5473 "age8481a.cs"
in_.p1_type= 0;((HPSL_INT16*)in_.p1)->num=(card);
//#line 5473 "age8481a.cs"
((HPSL_INT16*)in_.p1)->suffix=0;
//#line 5473 "age8481a.cs"
{extern sw_diag_intline_q();if (!instr_query(vi,sw_diag_intline_q,&in_,&out_)){
//#line 5473 "age8481a.cs"
*line=(*(HPSL_INT16*)out_.p1).num;}}}}
		if (old_error != instr_error_head(vi))
			age8481a_LOG_STATUS(vi, thisPtr, VI_ERROR_PARAMETER2);
	}
	age8481a_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/****************************************************************************
age8481a_trigImm
*****************************************************************************
    Parameter Name                                       Type    Direction
   ------------------------------------------------------------------------
  | vi                                                ViSession   IN
  |   ---------------------------------------------------------------------
  |  | Instrument Handle returned from age8481a_init()

*****************************************************************************/
ViStatus _VI_FUNC age8481a_trigImm (INST vi)
{
	ViUInt16 intf;
	ViStatus errStatus = 0;
	struct age8481a_globals *thisPtr;

	viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
	if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
	{
		errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViPAddr) &thisPtr);
	}
	else
	{
		errStatus = instr_getdata( vi,  (ViPAddr) &thisPtr);
	}
	if ( VI_SUCCESS > errStatus)
	{
		age8481a_LOG_STATUS(vi, NULL, errStatus );
	}
	age8481a_DEBUG_CHK_THIS( vi, thisPtr );
	age8481a_CDE_INIT( "age8481a_trg" );

	if (thisPtr->e1406)
	{
		errStatus = viPrintf(vi,":TRIGGER:IMM;\n");
		if ( VI_SUCCESS > errStatus)
		{
			age8481a_LOG_STATUS(vi, thisPtr, errStatus );
		}
	}
	else
	{
		{{ 
//#line 5522 "age8481a.cs"
{extern sw_trigimm();instr_send(vi,sw_trigimm,(void*)0);}}}
	}
	age8481a_LOG_STATUS(vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC age8481a_routPattern
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  age8481a_routPattern chooses a pattern number to be
 *            downloaded to.
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViInt16 card
 * IN        
 *            Numeric value of the module (card) to be disabled in a
 *           switchbox.
 * 
 *      MAX = age8481a_CARD_MAX   99
 *      MIN = age8481a_CARD_MIN   1
 *
 * PARAM 3 : ViInt16 pattern
 * IN
 *            Numeric value of the pattern.
 *
 *		MAX = age8481a_PATTERN_MAX	510
 *		MIN = age8481a_PATTERN_MIN	0
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "age8481a_error_message".
 * 
 *-----------------------------------------------------------------------------
 */

ViStatus _VI_FUNC age8481a_routPattern(INST vi,
									   ViInt16 card,
									   ViInt16 pattern)
{
	ViUInt16 intf;
	ViStatus errStatus = 0;
	struct age8481a_globals *thisPtr;

	viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
	if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
	{
		errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViPAddr) &thisPtr);
	}
	else
	{
		errStatus = instr_getdata( vi,  (ViPAddr) &thisPtr);
	}
	if ( VI_SUCCESS > errStatus)
	{
		age8481a_LOG_STATUS(vi, NULL, errStatus );
	}
	age8481a_DEBUG_CHK_THIS( vi, thisPtr );
	age8481a_CDE_INIT( "age8481a_routPattern" );

	/* Perform Error Checking on Each Parameter */
	age8481a_CHK_INT_RANGE(card, age8481a_CARD_MIN,
						   age8481a_CARD_MAX, VI_ERROR_PARAMETER2);
	age8481a_CHK_INT_RANGE(pattern, age8481a_PATTERN_MIN,
						   age8481a_PATTERN_MAX, VI_ERROR_PARAMETER3);
	if (thisPtr->e1406)
	{
		errStatus = viPrintf(vi,"PATTERN:NUMBER %d, %d\n", card, pattern);
		if ( VI_SUCCESS > errStatus)
		{
			age8481a_LOG_STATUS(vi, thisPtr, errStatus );
		}
	}
	else
	{
		{{ struct {short p1_type; char p1_type_pad[6]; double p1[1];short p2_type; char p2_type_pad[6]; double p2[1];} in_;
//#line 5599 "age8481a.cs"
in_.p1_type= 0;((HPSL_INT16*)in_.p1)->num=(card);
//#line 5599 "age8481a.cs"
((HPSL_INT16*)in_.p1)->suffix=0;
//#line 5599 "age8481a.cs"
in_.p2_type= 0;((HPSL_INT16*)in_.p2)->num=(pattern);
//#line 5599 "age8481a.cs"
((HPSL_INT16*)in_.p2)->suffix=0;
//#line 5599 "age8481a.cs"
{extern sw_patt_num();instr_send(vi,sw_patt_num,&in_);}}}
	}
	age8481a_LOG_STATUS(vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC age8481a_routPattern_Q
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  age8481a_routPattern queries which pattern is going to be
 *            downloaded to.
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViInt16 card
 * IN        
 *            Numeric value of the module (card) to be disabled in a
 *           switchbox.
 * 
 *      MAX = age8481a_CARD_MAX   99
 *      MIN = age8481a_CARD_MIN   1
 *
 * PARAM 3 : ViPInt16 pattern
 * OUT
 *            Returns the value of current pattern.
 *
 *		MAX = age8481a_PATTERN_MAX	510
 *		MIN = age8481a_PATTERN_MIN	0
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "age8481a_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
ViStatus _VI_FUNC age8481a_routPattern_Q(INST vi,
										 ViInt16 card,
										 ViPInt16 pattern)
{
	ViUInt16 intf;
	ViStatus errStatus = 0;
	struct age8481a_globals *thisPtr;

	viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
	if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
	{
		errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViPAddr) &thisPtr);
	}
	else
	{
		errStatus = instr_getdata(vi, (ViPAddr) &thisPtr);
	}
	if (VI_SUCCESS > errStatus)
	{
		age8481a_LOG_STATUS( vi, 0, errStatus );
	}

	age8481a_DEBUG_CHK_THIS( vi, thisPtr );
	age8481a_CDE_INIT( "age8481a_routPattern_Q" );

	/* Perform Error Checking on Each Parameter */
	age8481a_CHK_INT_RANGE(card, age8481a_CARD_MIN,
						   age8481a_CARD_MAX, VI_ERROR_PARAMETER2);
	if (thisPtr->e1406)
	{
		errStatus = viPrintf(vi,"PATTERN:NUMBER? %d\n", card);
		if (VI_SUCCESS > errStatus)
		{
			age8481a_LOG_STATUS( vi, thisPtr, errStatus );
		}
		errStatus = viScanf(vi,"%hd%*t",pattern);
		if (VI_SUCCESS > errStatus)
		{
			age8481a_LOG_STATUS( vi, thisPtr, errStatus );
		}
	}
	else
	{
		long old_error;
		old_error = instr_error_head(vi);
		{{ struct {short p1_type; char p1_type_pad[6]; double p1[1];} in_;struct {double p1[1];} out_;
//#line 5681 "age8481a.cs"
in_.p1_type= 0;((HPSL_INT16*)in_.p1)->num=(card);
//#line 5681 "age8481a.cs"
((HPSL_INT16*)in_.p1)->suffix=0;
//#line 5681 "age8481a.cs"
{extern sw_patt_num_q();if (!instr_query(vi,sw_patt_num_q,&in_,&out_)){
//#line 5681 "age8481a.cs"
*pattern=(*(HPSL_INT16*)out_.p1).num;}}}}
		if (old_error != instr_error_head(vi))
			age8481a_LOG_STATUS(vi, thisPtr, VI_ERROR_PARAMETER2);
	}
	age8481a_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC age8481a_routPattActivate
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  age8481a_routPattActivate loads a specified pattern stored
 *            into registers to operate relays.
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViInt16 card
 * IN        
 *            Numeric value of the module (card) to be disabled in a
 *           switchbox.
 * 
 *      MAX = age8481a_CARD_MAX   99
 *      MIN = age8481a_CARD_MIN   1
 *
 * PARAM 3 : ViInt16 pattern
 * IN
 *            Numeric value of the pattern.
 *
 *		MAX = age8481a_PATTERN_MAX	510
 *		MIN = age8481a_PATTERN_MIN	0
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "age8481a_error_message".
 * 
 *-----------------------------------------------------------------------------
 */

ViStatus _VI_FUNC age8481a_routPattActivate(INST vi,
											ViInt16 card,
											ViInt16 pattern)
{
	ViUInt16 intf;
	ViStatus errStatus = 0;
	struct age8481a_globals *thisPtr;

	viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
	if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
	{
		errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViPAddr) &thisPtr);
	}
	else
	{
		errStatus = instr_getdata( vi,  (ViPAddr) &thisPtr);
	}
	if ( VI_SUCCESS > errStatus)
	{
		age8481a_LOG_STATUS(vi, NULL, errStatus );
	}
	age8481a_DEBUG_CHK_THIS( vi, thisPtr );
	age8481a_CDE_INIT( "age8481a_routPattActivate" );

	/* Perform Error Checking on Each Parameter */
	age8481a_CHK_INT_RANGE(card, age8481a_CARD_MIN,
						   age8481a_CARD_MAX, VI_ERROR_PARAMETER2);
	age8481a_CHK_INT_RANGE(pattern, age8481a_PATTERN_MIN,
						   age8481a_PATTERN_MAX, VI_ERROR_PARAMETER3);
	if (thisPtr->e1406)
	{
		errStatus = viPrintf(vi,"PATTERN:ACTIVATE %d, %d\n", card, pattern);
		if ( VI_SUCCESS > errStatus)
		{
			age8481a_LOG_STATUS(vi, thisPtr, errStatus );
		}
	}
	else
	{
		{{ struct {short p1_type; char p1_type_pad[6]; double p1[1];short p2_type; char p2_type_pad[6]; double p2[1];} in_;
//#line 5760 "age8481a.cs"
in_.p1_type= 0;((HPSL_INT16*)in_.p1)->num=(card);
//#line 5760 "age8481a.cs"
((HPSL_INT16*)in_.p1)->suffix=0;
//#line 5760 "age8481a.cs"
in_.p2_type= 0;((HPSL_INT16*)in_.p2)->num=(pattern);
//#line 5760 "age8481a.cs"
((HPSL_INT16*)in_.p2)->suffix=0;
//#line 5760 "age8481a.cs"
{extern sw_patt_act();instr_send(vi,sw_patt_act,&in_);}}}
	}
	age8481a_LOG_STATUS(vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC age8481a_routPattActivate_Q
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  age8481a_routPattActivate queries which pattern was loaded
 *            into registers recently.
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViInt16 card
 * IN        
 *            Numeric value of the module (card) to be disabled in a
 *           switchbox.
 * 
 *      MAX = age8481a_CARD_MAX   99
 *      MIN = age8481a_CARD_MIN   1
 *
 * PARAM 3 : ViPInt16 pattern
 * OUT
 *            Returns the value of current pattern.
 *
 *		MAX = age8481a_PATTERN_MAX	510
 *		MIN = age8481a_PATTERN_MIN	0
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "age8481a_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
ViStatus _VI_FUNC age8481a_routPattActivate_Q(INST vi,
											  ViInt16 card,
											  ViPInt16 pattern)
{
	ViUInt16 intf;
	ViStatus errStatus = 0;
	struct age8481a_globals *thisPtr;

	viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
	if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
	{
		errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViPAddr) &thisPtr);
	}
	else
	{
		errStatus = instr_getdata(vi, (ViPAddr) &thisPtr);
	}
	if (VI_SUCCESS > errStatus)
	{
		age8481a_LOG_STATUS( vi, 0, errStatus );
	}

	age8481a_DEBUG_CHK_THIS( vi, thisPtr );
	age8481a_CDE_INIT( "age8481a_routPattActivate_Q" );

	/* Perform Error Checking on Each Parameter */
	age8481a_CHK_INT_RANGE(card, age8481a_CARD_MIN,
						   age8481a_CARD_MAX, VI_ERROR_PARAMETER2);
	if (thisPtr->e1406)
	{
		errStatus = viPrintf(vi,"PATTERN:ACTIVATE? %d\n", card);
		if (VI_SUCCESS > errStatus)
		{
			age8481a_LOG_STATUS( vi, thisPtr, errStatus );
		}
		errStatus = viScanf(vi,"%hd%*t",pattern);
		if (VI_SUCCESS > errStatus)
		{
			age8481a_LOG_STATUS( vi, thisPtr, errStatus );
		}
	}
	else
	{
		long old_error;
		old_error = instr_error_head(vi);
		{{ struct {short p1_type; char p1_type_pad[6]; double p1[1];} in_;struct {double p1[1];} out_;
//#line 5842 "age8481a.cs"
in_.p1_type= 0;((HPSL_INT16*)in_.p1)->num=(card);
//#line 5842 "age8481a.cs"
((HPSL_INT16*)in_.p1)->suffix=0;
//#line 5842 "age8481a.cs"
{extern sw_patt_act_q();if (!instr_query(vi,sw_patt_act_q,&in_,&out_)){
//#line 5842 "age8481a.cs"
*pattern=(*(HPSL_INT16*)out_.p1).num;}}}}
		if (old_error != instr_error_head(vi))
			age8481a_LOG_STATUS(vi, thisPtr, VI_ERROR_PARAMETER2);
	}
	age8481a_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC age8481a_routPattClosList
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  age8481a_routPattClosList specifies the opened channel list
 *            in a pattern. Before applying this command, be sure to call
 *            age8481a_routPattActivate() to choose which pattern to edit
 *            for all involved cards in the "channelList"
 *
 *            The channelList is in the form "ssrrcc", "ssrrcc,ssrrcc",
 *            or "ssrrcc:ccrc" where ss = card number (01-99),
 *            rr = matrix row number (0-3), and cc = matrix column number
 *            (00-31).
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViString channelList
 * IN        
 *            Channel list of the channels to be closed in a pattern. The 
 *           channelList is in the form "ssrrcc", "ssrrcc,ssrrcc", or 
 *           "ssrrcc:ssrrcc"  where ss = card number (01-99), rr = matrix
 *           row number(0-3) and cc = matrix column number (00-31).
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "age8481a_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
ViStatus _VI_FUNC age8481a_routPattClosList(INST vi,
											ViString channelList)
{
	ViUInt16 intf;
    ViStatus errStatus = 0;
    struct age8481a_globals *thisPtr;

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViPAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViPAddr) &thisPtr);
    }
    if (VI_SUCCESS > errStatus)
	{
		age8481a_LOG_STATUS( vi, 0, errStatus );
	}

    age8481a_DEBUG_CHK_THIS( vi, thisPtr );
    age8481a_CDE_INIT( "age8481a_routPattClosList" );

    if (thisPtr->e1406)
    {
        errStatus = viPrintf(vi,"PATTERN:CLOS (@%s)\n",channelList);
        if (errStatus < VI_SUCCESS)
        {
            age8481a_LOG_STATUS( vi, thisPtr, errStatus );
        }
    }
    else
    {
    	char *cmd = malloc(strlen(channelList)+20);
    	long old_error;
    
    	if (!cmd)
    	{
    		age8481a_CDE_ERROR( VI_ERROR_ALLOC );
    		age8481a_LOG_STATUS( vi, thisPtr, VI_ERROR_ALLOC );
    	}
    	strcpy(cmd, "PATTERN:CLOS (@");
    	strcat(cmd, channelList);
    	strcat(cmd, ")");
    	old_error = instr_error_head(vi);
    	cscpi_exe(vi, cmd, strlen(cmd), 0, 0);
    	free(cmd);
    	if (old_error != instr_error_head(vi))
    	{ /* must have been bad channel list*/
    		age8481a_LOG_STATUS( vi, thisPtr, VI_ERROR_PARAMETER2);
    	}
    }
    age8481a_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC age8481a_routPattClosList_Q
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  age8481a_routPattClosList_Q queries if the channel list 
 *            is closed in a specified pattern.
 *            The channelList is in the form "ssrrcc", "ssrrcc,ssrrcc",
 *            or "ssrrcc:ccrc" where ss = card number (01-99),
 *            rr = matrix row number (0-3), and cc = matrix column number
 *            (00-31). The function returns a comma separated list of 1's
 *            and 0's, 1 for each closed channel and 0 for each open channel.
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViString channelList
 * IN        
 *            Channel list of the channels to be queried. The channelList is
 *           in the form "ssrrcc", "ssrrcc,ssrrcc", or "ssrrcc:ssrrcc"  where
 *           ss = card number (01-99), rr = matrix row number (0-3) and cc = 
 *           matrix column number (00-31).
 * 
 * PARAM 3 : ViChar _VI_FAR routClosList[]
 * OUT       
 *           A comma separated list of 1's and 0's,
 *           1 for each closed channel and 0 for open channel.
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "age8481a_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
ViStatus _VI_FUNC age8481a_routPattClosList_Q(INST vi,
											  ViString channelList,
											  ViChar _VI_FAR routClosList[])

{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct age8481a_globals *thisPtr;

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViPAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViPAddr) &thisPtr);
    }
    if (VI_SUCCESS > errStatus)
	{
		age8481a_LOG_STATUS( vi, 0, errStatus );
	}

    age8481a_DEBUG_CHK_THIS( vi, thisPtr );
    age8481a_CDE_INIT( "age8481a_routPattClosList_Q" );

    if (thisPtr->e1406)
    {
        thisPtr->blockSrqIO = VI_TRUE;
        errStatus = viPrintf(vi,"PATT:CLOS? (@%s)\n",channelList);
        if (errStatus < VI_SUCCESS)
        {
            age8481a_LOG_STATUS( vi, thisPtr, errStatus );
        }
        errStatus = viScanf(vi,"%t",routClosList);
        if (errStatus < VI_SUCCESS)
        {
            age8481a_LOG_STATUS( vi, thisPtr, errStatus );
        }
        /* remove trailing newline */
        if (routClosList[0])
    	routClosList[strlen(routClosList)-1] = 0;	
        else
        {
    	age8481a_LOG_STATUS( vi, thisPtr, VI_ERROR_PARAMETER2);
        }
    }
    else
    {
    	char *cmd = malloc(strlen(channelList)+20);
    	long old_error;
    
    	if (!cmd)
    	{
    		age8481a_CDE_ERROR( VI_ERROR_ALLOC );
    		age8481a_LOG_STATUS( vi, thisPtr, VI_ERROR_ALLOC );
    	}
    	strcpy(cmd, "PATT:CLOS? (@");
    	strcat(cmd, channelList);
    	strcat(cmd, ")");
    	old_error = instr_error_head(vi);
    	cscpi_exe(vi, cmd, strlen(cmd), routClosList, 32700);
    	/* remove trailing newline */
    	if (routClosList[0])
    		routClosList[strlen(routClosList)-1] = 0;	
    	else
    	{
    		age8481a_LOG_STATUS( vi, thisPtr, VI_ERROR_PARAMETER2);
    	}
    	if (old_error != instr_error_head(vi))
    	{ /* must have been bad channel list*/
    		age8481a_LOG_STATUS( vi, thisPtr, VI_ERROR_PARAMETER2);
    	}
    	free(cmd);
    }
    age8481a_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC age8481a_routPattOpenList
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  age8481a_routPattOpenList spefies the opened channel list
 *            in a pattern. Before applying this command, be sure to call
 *            age8481a_routPattActivate() to choose which pattern to edit
 *            for all involved cards in the "channelList".
 *            The channelList is in the form "ssrrcc", "ssrrcc,ssrrcc",
 *            or "ssrrcc:ccrc" where ss = card number (01-99),
 *            rr = matrix row number (0-3), and cc = matrix column number
 *            (00-31).
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViString channelList
 * IN        
 *            Channel list of the channels to be opened. The channelList is
 *           in the form The channelList is in the form "ssrrcc",
 *           "ssrrcc,ssrrcc", or "ssrrcc:ccrc" where ss = card number
 *           (01-99), rr = matrix row number (0-3), and cc = matrix column
 *           number (00-31).
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "age8481a_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
ViStatus _VI_FUNC age8481a_routPattOpenList(INST vi,
											ViString channelList)
{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct age8481a_globals *thisPtr;

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViPAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViPAddr) &thisPtr);
    }
    if (VI_SUCCESS > errStatus)
	{
		age8481a_LOG_STATUS( vi, 0, errStatus );
	}

    age8481a_DEBUG_CHK_THIS( vi, thisPtr );
    age8481a_CDE_INIT( "age8481a_routPattOpenList" );

    if (thisPtr->e1406)
    {
        errStatus = viPrintf(vi,"PATTERN:OPEN (@%s)\n",channelList);
        if (errStatus < VI_SUCCESS)
        {
            age8481a_LOG_STATUS( vi, thisPtr, errStatus );
        }
    }
    else
    {
    	char *cmd = malloc(strlen(channelList)+20);
    	long old_error;
    
    	if (!cmd)
    	{
    		age8481a_CDE_ERROR( VI_ERROR_ALLOC );
    		age8481a_LOG_STATUS( vi, thisPtr, VI_ERROR_ALLOC );
    	}
    	strcpy(cmd, "PATTERN:OPEN (@");
    	strcat(cmd, channelList);
    	strcat(cmd, ")");
    	old_error = instr_error_head(vi);
    	cscpi_exe(vi, cmd, strlen(cmd), 0, 0);
    	free(cmd);
    	if (old_error != instr_error_head(vi))
    	{ /* must have been bad channel list*/
    		age8481a_LOG_STATUS( vi, thisPtr, VI_ERROR_PARAMETER2);
    	}
    }
    age8481a_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC age8481a_routPattOpenList_Q
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  age8481a_routPattOpenList_Q returns the
 *            current state of the channels queried in a specified pattern.
 *            The channelList is in the form "ssrrcc", "ssrrcc,ssrrcc",
 *            or "ssrrcc:ccrc" where ss = card number (01-99),
 *            rr = matrix row number (0-3), and cc = matrix column number
 *            (00-31). The function returns a comma separated list of 1's
 *            and 0's, 1 for each open channel and 0 for each closed channel.
 * 
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 * 
 * PARAM 2 : ViString channelList
 * IN        
 *            Channel list of the channels to be queried. The channelList is
 *           in the form The channelList is in the form "ssrrcc",
 *           "ssrrcc,ssrrcc", or "ssrrcc:ccrc" where ss = card number
 *           (01-99), rr = matrix row number (00-03), and cc = matrix column
 *           number (00-31).
 * 
 * PARAM 3 : ViChar _VI_FAR routOpenList[]
 * OUT       
 *           A comma separated list of 1's and 0's,
 *           1 for each open channel and 0 for closed channel.
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "age8481a_error_message".
 * 
 *-----------------------------------------------------------------------------
 */
ViStatus _VI_FUNC age8481a_routPattOpenList_Q(INST vi,
											  ViString channelList,
											  ViChar _VI_FAR routOpenList[])

{
    ViUInt16 intf;
    ViStatus errStatus = 0;
    struct age8481a_globals *thisPtr;

    viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
    if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
    {
        errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViPAddr) &thisPtr);
    }
    else
    {
        errStatus = instr_getdata(vi, (ViPAddr) &thisPtr);
    }
    if (VI_SUCCESS > errStatus)
	{
		age8481a_LOG_STATUS( vi, 0, errStatus );
	}

    age8481a_DEBUG_CHK_THIS( vi, thisPtr );
    age8481a_CDE_INIT( "age8481a_routPattOpenList_Q" );

    if (thisPtr->e1406)
    {
        thisPtr->blockSrqIO = VI_TRUE;
        errStatus = viPrintf(vi,"PATTERN:OPEN? (@%s)\n",channelList);
        if (errStatus < VI_SUCCESS)
        {
            age8481a_LOG_STATUS( vi, thisPtr, errStatus );
        }
        errStatus = viScanf(vi,"%t",routOpenList);
        if (errStatus < VI_SUCCESS)
        {
            age8481a_LOG_STATUS( vi, thisPtr, errStatus );
        }
        /* remove trailing newline */
        if (routOpenList[0])
    	routOpenList[strlen(routOpenList)-1] = 0;	
        else
        {
    	age8481a_LOG_STATUS( vi, thisPtr, VI_ERROR_PARAMETER2);
        }
    }
    else
    {
    	char *cmd = malloc(strlen(channelList)+20);
    	long old_error;
    
    	if (!cmd)
    	{
    		age8481a_CDE_ERROR( VI_ERROR_ALLOC );
    		age8481a_LOG_STATUS( vi, thisPtr, VI_ERROR_ALLOC );
    	}
    	strcpy(cmd, "PATTERN:OPEN? (@");
    	strcat(cmd, channelList);
    	strcat(cmd, ")");
    	old_error = instr_error_head(vi);
    	cscpi_exe(vi, cmd, strlen(cmd), routOpenList, 32700);
    	/* remove trailing newline */
    	if (routOpenList[0])
    		routOpenList[strlen(routOpenList)-1] = 0;	
    	else
    	{
    		age8481a_LOG_STATUS( vi, thisPtr, VI_ERROR_PARAMETER2);
    	}
    	if (old_error != instr_error_head(vi))
    	{ /* must have been bad channel list*/
    		age8481a_LOG_STATUS( vi, thisPtr, VI_ERROR_PARAMETER2);
    	}
    	free(cmd);
    }
    age8481a_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC age8481a_routFunc
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  age8481a_routFunc sets the
 *
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 *    
 * PARAM 2 : ViInt16 card
 * IN        
 *            Numeric value of the module (card) to be disabled in a
 *           switchbox.
 * 
 *      MAX = age8481a_CARD_MAX   99
 *      MIN = age8481a_CARD_MIN   1
 * 
 * PARAM 3 : CString cMode
 * OUT       
 *
 * 
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "age8481a_error_message".
 * 
 *-----------------------------------------------------------------------------
 *
SINGLE4X32, DUAL4X16
 */

ViStatus _VI_FUNC age8481a_routFunc (INST vi,
									 ViInt16 card,
									 ViString cMode)
{
	ViUInt16 intf;
	ViStatus errStatus = 0;
	struct age8481a_globals *thisPtr;

	viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
	if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
	{
		errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViPAddr) &thisPtr);
	}
	else
	{
		errStatus = instr_getdata( vi,  (ViPAddr) &thisPtr);
	}
	if ( VI_SUCCESS > errStatus)
	{
		age8481a_LOG_STATUS(vi, NULL, errStatus );
	}
	age8481a_DEBUG_CHK_THIS( vi, thisPtr );
	age8481a_CDE_INIT( "age8481a_routFunc" );
	/* Perform Error Checking on Each Parameter */
	age8481a_CHK_INT_RANGE(card, age8481a_CARD_MIN,
						   age8481a_CARD_MAX, VI_ERROR_PARAMETER2);

	if (thisPtr->e1406)
	{
		errStatus = viPrintf(vi,"FUNCTION %d, %s\n", card, cMode);
		if ( VI_SUCCESS > errStatus)
		{
			age8481a_LOG_STATUS(vi, thisPtr, errStatus );
		}
	}
	else
	{
		{{ struct {short p1_type; char p1_type_pad[6]; double p1[1];short p2_type; char p2_type_pad[6]; double p2[1];} in_;
//#line 6316 "age8481a.cs"
extern CSCPI_IMPORT void *Eswitch_enum_SINGLE4X32DUAL4X1631[];char f_=0;
//#line 6316 "age8481a.cs"
in_.p1_type= 0;((HPSL_INT16*)in_.p1)->num=(card);
//#line 6316 "age8481a.cs"
((HPSL_INT16*)in_.p1)->suffix=0;
//#line 6316 "age8481a.cs"
in_.p2_type= 2;*(HPSL_ENUM*)in_.p2=char_to_enum(Eswitch_enum_SINGLE4X32DUAL4X1631,cMode,vi, &f_);
//#line 6316 "age8481a.cs"
if (!f_) {extern sw_func();instr_send(vi,sw_func,&in_);}}}
	}
	age8481a_LOG_STATUS(vi, thisPtr, VI_SUCCESS );
}

/*-----------------------------------------------------------------------------
 * FUNC    : ViStatus _VI_FUNC age8481a_routFunc_Q
 *-----------------------------------------------------------------------------
 * 
 * PURPOSE :  age8481a_routFunc_Q queriess the
 *
 * PARAM 1 : ViSession vi
 * IN        
 *            The handle to the instrument.
 *    
 * PARAM 2 : ViInt16 card
 * IN        
 *            Numeric value of the module (card) to be disabled in a
 *           switchbox.
 * 
 *      MAX = age8481a_CARD_MAX   99
 *      MIN = age8481a_CARD_MIN   1
 * 
 * PARAM 3 : CString cMode
 * OUT       
 *
 * RETURN  :  VI_SUCCESS: No error. Non VI_SUCCESS: Indicates error
 *           condition. To determine error message, pass the return value to
 *           routine "age8481a_error_message".
 * 
 *-----------------------------------------------------------------------------
 *
SINGLE4X32, DUAL4X16
 */

ViStatus _VI_FUNC age8481a_routFunc_Q (INST vi,
									   ViInt16 card,
									   ViChar _VI_FAR cMode[])
{
	ViUInt16 intf;
	ViStatus errStatus = 0;
	struct age8481a_globals *thisPtr;

	viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
	if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
	{
		errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViPAddr) &thisPtr);
	}
	else
	{
		errStatus = instr_getdata(vi, (ViPAddr) &thisPtr);
	}
	if (VI_SUCCESS > errStatus)
	{
		age8481a_LOG_STATUS( vi, 0, errStatus );
	}

	age8481a_DEBUG_CHK_THIS( vi, thisPtr );
	age8481a_CDE_INIT( "age8481a_routFunc_Q" );

	/* Perform Error Checking on Each Parameter */
	age8481a_CHK_INT_RANGE(card, age8481a_CARD_MIN,
						   age8481a_CARD_MAX, VI_ERROR_PARAMETER2);
	if (thisPtr->e1406)
	{
		errStatus = viPrintf(vi,"FUNCTION? %d\n", card);
		if (VI_SUCCESS > errStatus)
		{
			age8481a_LOG_STATUS( vi, thisPtr, errStatus );
		}
		errStatus = viScanf(vi,"%t",cMode);
		if (VI_SUCCESS > errStatus)
		{
			age8481a_LOG_STATUS( vi, thisPtr, errStatus );
		}
	}
	else
	{
		long old_error;
		old_error = instr_error_head(vi);
		{{ struct {short p1_type; char p1_type_pad[6]; double p1[1];} in_;struct {double p1[1];} out_;
//#line 6396 "age8481a.cs"
extern CSCPI_IMPORT void *Eswitch_enum_SINGLE4X32DUAL4X1631[];
//#line 6396 "age8481a.cs"
in_.p1_type= 0;((HPSL_INT16*)in_.p1)->num=(card);
//#line 6396 "age8481a.cs"
((HPSL_INT16*)in_.p1)->suffix=0;
//#line 6396 "age8481a.cs"
{extern sw_func_q();if (!instr_query(vi,sw_func_q,&in_,&out_)){
//#line 6396 "age8481a.cs"
enum_to_char(cMode, Eswitch_enum_SINGLE4X32DUAL4X1631, *(HPSL_ENUM*)out_.p1);}}}}
		if (old_error != instr_error_head(vi))
			age8481a_LOG_STATUS(vi, thisPtr, VI_ERROR_PARAMETER2);
	}
	age8481a_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*
 */
ViStatus _VI_FUNC age8481a_operEvent_Q(ViSession vi,
									   ViPInt32 operEventRegister)
{
	ViUInt16 intf;
	ViStatus errStatus = 0;
	struct age8481a_globals *thisPtr;

	viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
	if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
	{
		errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViPAddr) &thisPtr);
	}
	else
	{
		errStatus = instr_getdata(vi, (ViPAddr) &thisPtr);
	}
	if (VI_SUCCESS > errStatus)
	{
		age8481a_LOG_STATUS( vi, 0, errStatus );
	}

	age8481a_DEBUG_CHK_THIS( vi, thisPtr );
	age8481a_CDE_INIT( "age8481a_operEvent_Q" );

	if (thisPtr->e1406)
	{
		errStatus = viPrintf(vi,"STATUS:OPERATION:EVENT?\n");
		if (VI_SUCCESS > errStatus)
		{
			age8481a_LOG_STATUS( vi, thisPtr, errStatus );
		}
		errStatus = viScanf(vi,"%hd%*t",operEventRegister);
		if (VI_SUCCESS > errStatus)
		{
			age8481a_LOG_STATUS( vi, thisPtr, errStatus );
		}
	}
	else
	{
		long old_error;
		old_error = instr_error_head(vi);
		{{ struct {short sub1;char sub_pad[6];} in_;struct {double p1[1];} out_;
//#line 6446 "age8481a.cs"
in_.sub1= 3;
//#line 6446 "age8481a.cs"
{extern stat_even_q();if (!instr_query(vi,stat_even_q,&in_,&out_)){
//#line 6446 "age8481a.cs"
*operEventRegister=(*(HPSL_INT16*)out_.p1).num;}}}}
		if (old_error != instr_error_head(vi))
        { /* must have been bad card number*/
            age8481a_LOG_STATUS( vi, thisPtr, VI_ERROR_PARAMETER2);
        }
	}
	age8481a_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

/*
 */
ViStatus _VI_FUNC age8481a_operCond_Q(ViSession vi,
									  ViPInt32 operCondRegister)
{
	ViUInt16 intf;
	ViStatus errStatus = 0;
	struct age8481a_globals *thisPtr;

	viGetAttribute( vi, VI_ATTR_INTF_TYPE, &intf);
	if (intf!=VI_INTF_VXI && intf!=VI_INTF_GPIB_VXI)
	{
		errStatus = viGetAttribute(vi, VI_ATTR_USER_DATA, (ViPAddr) &thisPtr);
	}
	else
	{
		errStatus = instr_getdata(vi, (ViPAddr) &thisPtr);
	}
	if (VI_SUCCESS > errStatus)
	{
		age8481a_LOG_STATUS( vi, 0, errStatus );
	}

	age8481a_DEBUG_CHK_THIS( vi, thisPtr );
	age8481a_CDE_INIT( "age8481a_operCond_Q" );

	if (thisPtr->e1406)
	{
		errStatus = viPrintf(vi,"STATUS:OPERATION:COND?\n");
		if (VI_SUCCESS > errStatus)
		{
			age8481a_LOG_STATUS( vi, thisPtr, errStatus );
		}
		errStatus = viScanf(vi,"%hd%*t",operCondRegister);
		if (VI_SUCCESS > errStatus)
		{
			age8481a_LOG_STATUS( vi, thisPtr, errStatus );
		}
	}
	else
	{
		long old_error;
		old_error = instr_error_head(vi);
		{{ struct {short sub1;char sub_pad[6];} in_;struct {double p1[1];} out_;
//#line 6498 "age8481a.cs"
in_.sub1= 3;
//#line 6498 "age8481a.cs"
{extern stat_cond_q();if (!instr_query(vi,stat_cond_q,&in_,&out_)){
//#line 6498 "age8481a.cs"
*operCondRegister=(*(HPSL_INT16*)out_.p1).num;}}}}
		if (old_error != instr_error_head(vi))
        { /* must have been bad card number*/
            age8481a_LOG_STATUS( vi, thisPtr, VI_ERROR_PARAMETER2);
        }
	}
	age8481a_LOG_STATUS( vi, thisPtr, VI_SUCCESS );
}

